/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

/**
 * 薪资详情里的报账导出-EKP附件专用
 * 薪资详情里的报账导出，是前端导出，此处后端导出，给EKP项目订单获取附件使用的
 *
 * @author hgw
 * @date 2024-4-18 17:04:21
 */
@Data
@Schema(description = "薪资详情里的报账导出-EKP附件专用")
@HeadFontStyle(fontHeightInPoints = 11)
public class TSalaryTypeThreeExportEkpVo {


	//薪酬状态,项目名称,项目编码,发放月份,薪酬月份,员工姓名,身份证号,手机号码,银行卡号,开户行总行
	// 开户行省,开户行市,开户行支行,劳务费,工资发放时间,是否个人承担部分税费
	// 个税-个人承担,个税-单位承担,公司应发,个人实收,本月是否重复金额,是否自有员工,是否发薪员工,支出结算状态
	@ExcelProperty("薪酬状态")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String status;
	@ExcelProperty("项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String deptName;
	@ExcelProperty("项目编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String deptNo;
	@ExcelProperty("发放月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String settlementMonth;
	@ExcelProperty("薪酬月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String salaryMonth;
	@ExcelProperty("员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String empName;
	@ExcelProperty("身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String empIdcard;
	@ExcelProperty("手机号码")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String empPhone;
	// 银行卡号
	@ExcelProperty("银行卡号")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String bankNo;
	// 开户行总行
	@ExcelProperty("开户行总行")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String bankName;
	// 开户行省
	@ExcelProperty("开户行省")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String bankProvince;
	// ,开户行市,开户行支行,工资发放方式,工资发放时间,社保缴纳月份,公积金缴纳月份,社保优先级,公积金优先级,是否扣除社保,是否扣除公积金
	// 开户行市
	@ExcelProperty("开户行市")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String bankCity;
	// 开户行支行
	@ExcelProperty("开户行支行")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String bankSubName;
	// 劳务费   应发薪酬（劳务费、稿酬）
	@ExcelProperty("劳务费")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String relaySalary;
	// 工资发放时间（0立即发、1暂停发）
	@ExcelProperty("工资发放时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String salaryGiveTime;
	/**
	 * 是否个人承担部分税费
	 * 公司承担全部税费0
	 * 个人承担部分税费1
	 * 个人承担全部税费2
	 */
	@ExcelProperty("是否个人承担部分税费")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String isPersonTax;

	/**
	 * 个税金额（个人承担）
	 */
	@ExcelProperty("个税-个人承担")
	@HeadFontStyle(fontHeightInPoints = 11)
	private BigDecimal salaryTax;

	/**
	 * 个税-单位承担
	 */
	@ExcelProperty("个税-单位承担")
	@HeadFontStyle(fontHeightInPoints = 11)
	private BigDecimal salaryTaxUnit;
	/**
	 * 公司应发
	 */
	@ExcelProperty("公司应发")
	@HeadFontStyle(fontHeightInPoints = 11)
	private BigDecimal relaySalaryUnit;
	/**
	 * 实发（个人实收）
	 */
	@ExcelProperty("个人实收")
	@HeadFontStyle(fontHeightInPoints = 11)
	private BigDecimal actualSalary;
	// ,本月是否重复金额,是否自有员工,是否薪资特殊值,支出结算状态
	// 本月是否重复金额0：否；1：是重复导入的
	@ExcelProperty("本月是否重复金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String isRepeat;
	// 是否自有员工0：否；1：是自有员工
	@ExcelProperty("是否自有员工")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String ownFlag;
	//劳务费、稿酬是否含有发薪0：否；1：是
	@ExcelProperty("是否发薪员工")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String haveSalaryFlag;
	@ExcelProperty("支出结算状态")
	@HeadFontStyle(fontHeightInPoints = 11)
	private String paySettleFlag;
}
