/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 项目档案表excel对应的实体
 *
 * @author huyc
 * @date 2022-06-20 17:54:40
 */
@Data
@ColumnWidth(30)
public class HcmEmployeeInfoVO extends RowIndex implements Serializable {

	private static final long serialVersionUID = 1L;

	// 基本信息
	private HcmArchiveBasicVo archiveBasic;
	// 工作经历
	private List<HcmArchiveJobVo> archiveJob;
	// 教育经历-含附件
	private List<HcmArchiveEducationVo> archiveEducation;
	// 资格证书-含附件
	private List<HcmArchiveCertificateVo> archiveCertificate;
	// 家庭成员
	private List<HcmArchiveFamilyVo> archiveFamily;
	// 合同信息-含附件
	private List<HcmContractVo> contract;

	// 不良记录
	private List<HcmArchiveBadRecordVo> archiveBadRecord;


}
