package com.yifu.cloud.plus.v1.business.util;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;

/**
 * @author hgw
 * @Description: 工资表上传公共类
 */
public class SalaryUtil implements Serializable {

     /**
      * @param c
      * @param attr
      * @Description: 验证属性的值的长度
      * @Author: hgw
      * @Date: 2021/9/17 9:47
      * @return: java.lang.String
      **/
     public static void validateData(String c, ExcelAttribute attr, List<ErrorMessage> errorList, int i) {
          //最大长度校验
          if (Common.isNotNull(c) && Common.isNotNull(attr) ) {
               if (attr.isDate()) {
                    try {
                         DateFormat df = new SimpleDateFormat(attr.dateFormat());
                         df.parse(c.trim());
                    } catch (ParseException e) {
                         errorList.add(new ErrorMessage(i, attr.name() + "列：日期格式不正确[正确格式‘199101’]，实际：" + c));
                    }
               }
               if (attr.maxLength() > 0 && c.length() > attr.maxLength()) {
                    errorList.add(new ErrorMessage(i, attr.name() + "列：超出最大长度[" + attr.maxLength() + "]：" + c));
               }
          }
     }

     /**
      * @param field
      * @param cellValueStr
      * @param fieldType
      * @param entity
      * @Description: 总入口：塞属性
      * @Author: hgw
      * @Date: 2021/1/11 11:18
      * @return: void
      **/
     public static <T> void setFields(Field field, String cellValueStr, Class<?> fieldType, T entity) throws IllegalAccessException {
          if (String.class == fieldType) {
               setStringField(field, cellValueStr, entity);
          } else if (BigDecimal.class == fieldType) {
               setBigDecimalField(field, cellValueStr, entity);
          } else if ((Integer.TYPE == fieldType) || (Integer.class == fieldType)) {
               setIntegerField(field, cellValueStr, entity);
          }
     }

     /**
      * @param field
      * @param cellValueStr
      * @param entity
      * @Description: 判断整型
      * @Author: hgw
      * @Date: 2021/1/11 11:48
      * @return: void
      **/
     private static <T> void setIntegerField(Field field, String cellValueStr, T entity) throws IllegalAccessException {
          if ("否".equals(cellValueStr)) {
               field.set(entity, 0);
          } else if ("是".equals(cellValueStr)) {
               field.set(entity, 1);
          } else {
               field.set(entity, Integer.parseInt(Common.isEmpty(cellValueStr)?"0":cellValueStr));
          }
     }

     /**
      * @param field
      * @param cellValueStr
      * @param entity
      * @Description: 判断金额
      * @Author: hgw
      * @Date: 2021/1/11 11:48
      * @return: void
      **/
     private static <T> void setBigDecimalField(Field field, String cellValueStr, T entity) throws IllegalAccessException {
          if (cellValueStr.indexOf('%') != -1) {
               cellValueStr = cellValueStr.replace("%", "");
          }
          field.set(entity, BigDecimal.valueOf(Double.valueOf(cellValueStr)));
     }

     /**
      * @param field
      * @param cellValueStr
      * @param entity
      * @Description: 判断固定字符串，塞值
      * @Author: hgw
      * @Date: 2021/1/11 11:47
      * @return: void
      **/
     private static <T> void setStringField(Field field, String cellValueStr, T entity) throws IllegalAccessException {
          if ("否".equals(cellValueStr)) {
               field.set(entity, "0");
          } else if ("是".equals(cellValueStr)) {
               field.set(entity, "1");
          } else if ("暂停发".equals(cellValueStr)) {
               field.set(entity, "1");
          } else if ("立即发".equals(cellValueStr)) {
               field.set(entity, "0");
          } else if ("现金".equals(cellValueStr)) {
               field.set(entity, "0");
          } else if ("银行".equals(cellValueStr)) {
               field.set(entity, "1");
          } else if ("线下".equals(cellValueStr)) {
               field.set(entity, "2");
          } else if ("合并".equals(cellValueStr)) {
               field.set(entity, "0");
          } else if ("单独".equals(cellValueStr)) {
               field.set(entity, "1");
          } else {
               field.set(entity, cellValueStr);
          }
     }

}
