/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author huyc
 * @date 2024-03-13 16:14:37
 */
@Data
@TableName("ekp_manager_info")
@EqualsAndHashCode()
@Schema(description = "管理费明细表")
public class EkpManagerInfo {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "id")
	private String fdId;
	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String fd_3adfef5e5b9d34;
	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	private String fd_3adfef5eb6691c;
	/**
	 * 单号
	 */
	@Schema(description = "单号")
	private String fd_3adfef7f5d2b52;
	/**
	 * 客户编码
	 */
	@Schema(description = "客户编码")
	private String fd_3adfef80202ab2;
	/**
	 * 客户名称
	 */
	@Schema(description = "客户名称")
	private String fd_3adfef7fc1c886;
	/**
	 * 类型
	 */
	@Schema(description = "类型")
	private String fd_3adda3037e3bda;
	/**
	 * 产生来源
	 */
	@Schema(description = "产生来源")
	private String fd_3adda320daef5a;
	/**
	 * 姓名
	 */
	@Schema(description = "姓名")
	private String fd_3adfef948da848;
	/**
	 * 身份证号
	 */
	@Schema(description = "身份证号")
	private String fd_3adfef94dcdbb4;
	/**
	 * 管理费金额
	 */
	@Schema(description = "管理费金额")
	private Double fd_3adfef963bae28;
	/**
	 * 应收
	 */
	@Schema(description = "应收")
	private Double fd_3adfefa3daae72;
	/**
	 * 结算状态
	 */
	@Schema(description = "结算状态")
	private String fd_3adfefaaa3bbd0;
	/**
	 * 收款状态
	 */
	@Schema(description = "收款状态")
	private String fd_3adfefaaef583e;
	/**
	 * 实际结算月份
	 */
	@Schema(description = "实际结算月份")
	private String fd_3ae0c23cb3fccc;
	/**
	 * 生成月份
	 */
	@Schema(description = "生成月份")
	private String fd_3ae0c23b2e9a92;
	/**
	 * 结算单号
	 */
	@Schema(description = "结算单号")
	private String fd_3aead3c68b1078;
	/**
	 * 收款单号
	 */
	@Schema(description = "收款单号")
	private String fd_3aeae58b14691c;
	/**
	 * 数据来源
	 */
	@Schema(description = "数据来源")
	private String fd_3b0b7231bb5896;
	/**
	 * 是否全部结算
	 */
	@Schema(description = "是否全部结算")
	private String fd_3b13b15f5b63fa;
	/**
	 * 管理费ID
	 */
	@Schema(description = "管理费ID")
	private String fd_3b13dc864a3052;
	/**
	 * HRO结算月
	 */
	@Schema(description = "HRO结算月")
	private String fd_3b13dd215b55b2;
	/**
	 * 项目台账ID(ID)
	 */
	@Schema(description = "项目台账ID(ID)")
	private String fd_3b16e47cb6874c;
	/**
	 * 项目台账ID
	 */
	@Schema(description = "项目台账ID")
	private String fd_3b16e47cb6874c_text;
	/**
	 * 薪酬申请编号
	 */
	@Schema(description = "薪酬申请编号")
	private String fd_3b3bf110837a96;
	/**
	 * 变更记录
	 */
	@Schema(description = "变更记录")
	private String fd_3b3e43a10ab4b2;
	
	@Schema(description = "创建时间")
	private Date createTime;

}
