package com.yifu.cloud.plus.v1.ekp.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.ekp.entity.EkpRiskInfo;
import com.yifu.cloud.plus.v1.ekp.mapper.EkpRiskInfoMapper;
import com.yifu.cloud.plus.v1.ekp.service.EkpRiskInfoService;
import com.yifu.cloud.plus.v1.ekp.vo.EkpDeptInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpIncomePushInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpSocialPushInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.LocalDateTimeUtils;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpIncomeParamRisk;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * @author huyc
 * @date 2024-03-13 16:14:37
 */
@Log4j2
@Service
public class EkpRiskInfoServiceImpl extends ServiceImpl<EkpRiskInfoMapper, EkpRiskInfo> implements EkpRiskInfoService {

	/**
	 * //@Description: 风险金明细推送至ekp
	 * //@Author: huyc
	 * //@Date: 2024-3-14
	 * //@return: void
	 **/
	public EkpIncomePushInfoVo pushRiskInfoToEkp(EkpIncomeParamRisk incomeParam) {
		//根据项目编码获取ekp所有项目信息
		EkpDeptInfoVo deptInfo = baseMapper.getEkpDeptInfoByNo(incomeParam.getFd_3adfef5e5b9d34());
		if (null == deptInfo) {
			return null;
		}
		EkpRiskInfo riskInfoCount;
		try {
			//去重 防止重复推送
			riskInfoCount = baseMapper.selectOne(Wrappers.<EkpRiskInfo>query().lambda()
					.eq(EkpRiskInfo::getFd_3b13db120a8224, incomeParam.getFd_3b13dac4c03022())
					.last(CommonConstants.LAST_ONE_SQL));
			if (Optional.ofNullable(riskInfoCount).isPresent()) {
				return null;
			}
			EkpRiskInfo riskInfoInfo = new EkpRiskInfo();
			//对象信息赋值
			copyManagerProperties(incomeParam, riskInfoInfo);

			//项目信息
			riskInfoInfo.setFd_3b16e4cd2c9a86_text(deptInfo.getDeptName());
			riskInfoInfo.setFd_3b16e4cd2c9a86(deptInfo.getFdId());
			//实际结算月份
			if ("结算月本月数据".equals(deptInfo.getSocialType())) {
				riskInfoInfo.setFd_3ae0c3044e5958(incomeParam.getFd_3ae0c3044e5958());
			} else if ("结算月上月数据".equals(deptInfo.getSocialType())) {
				riskInfoInfo.setFd_3ae0c3044e5958(DateUtil.dateToString(DateUtil.addMonthByDate(DateUtil.parseDate(incomeParam.getFd_3ae0c3044e5958(), "yyyy-MM"), -1), "yyyy-MM"));
			} else {
				riskInfoInfo.setFd_3ae0c3044e5958("");
			}
			//是否全部结算
			riskInfoInfo.setFd_3b13b218b76a36("全量未结算数据".equals(deptInfo.getSocialType()) ? "是" : "否");
			//创建时间
			riskInfoInfo.setCreateTime(DateUtil.getCurrentDateTime());
			int i = baseMapper.insert(riskInfoInfo);
			if (i>0) {
				EkpIncomePushInfoVo infoVo = new EkpIncomePushInfoVo();
				infoVo.setId(riskInfoInfo.getFdId());
				return infoVo;
			} else {
				return null;
			}
		} catch (Exception e) {
			log.error("管理费明细推送失败:", e);
			return null;
		}
	}

	/**
	 * //@Description: 风险金明细推送至ekp
	 * //@Author: huyc
	 * //@Date: 2024-3-14
	 * //@return: void
	 **/
	public EkpSocialPushInfoVo jobPushRiskInfoToEkp(List<EkpIncomeParamRisk> incomeParamList) {
		List<String> paymentIds = new ArrayList<>();
		List<EkpRiskInfo> riskInfoList = new ArrayList();
		EkpRiskInfo riskInfoCount;
		EkpDeptInfoVo deptInfo;
		try {
			for (EkpIncomeParamRisk incomeParam : incomeParamList) {
				//根据项目编码获取ekp所有项目信息
				deptInfo = baseMapper.getEkpDeptInfoByNo(incomeParam.getFd_3adfef5e5b9d34());

				//去重 防止重复推送
				riskInfoCount = baseMapper.selectOne(Wrappers.<EkpRiskInfo>query().lambda()
						.eq(EkpRiskInfo::getFd_3b13db120a8224, incomeParam.getFd_3b13dac4c03022())
						.last(CommonConstants.LAST_ONE_SQL));
				if (Optional.ofNullable(riskInfoCount).isPresent()) {
					return null;
				}
				EkpRiskInfo riskInfoInfo = new EkpRiskInfo();
				//对象信息赋值
				copyManagerProperties(incomeParam, riskInfoInfo);

				//项目信息
				riskInfoInfo.setFd_3b16e4cd2c9a86_text(deptInfo.getDeptName());
				riskInfoInfo.setFd_3b16e4cd2c9a86(deptInfo.getFdId());
				//实际结算月份
				if ("结算月本月数据".equals(deptInfo.getSocialType())) {
					riskInfoInfo.setFd_3ae0c3044e5958(incomeParam.getFd_3ae0c3044e5958());
				} else if ("结算月上月数据".equals(deptInfo.getSocialType())) {
					riskInfoInfo.setFd_3ae0c3044e5958(DateUtil.dateToString(DateUtil.addMonthByDate(DateUtil.parseDate(incomeParam.getFd_3ae0c3044e5958(), "yyyy-MM"), -1), "yyyy-MM"));
				} else {
					riskInfoInfo.setFd_3ae0c3044e5958("");
				}
				//是否全部结算
				riskInfoInfo.setFd_3b13b218b76a36("全量未结算数据".equals(deptInfo.getSocialType()) ? "是" : "否");
				//创建时间
				riskInfoInfo.setCreateTime(DateUtil.getCurrentDateTime());
				paymentIds.add(riskInfoInfo.getFd_3b13db120a8224());
				riskInfoList.add(riskInfoInfo);
			}
			if (!riskInfoList.isEmpty()) {
				boolean flag = this.saveBatch(riskInfoList);
				if (flag) {
					//推送成功保存社保明细合并的数据对应关系
					EkpSocialPushInfoVo pushInfoVo = new EkpSocialPushInfoVo();
					pushInfoVo.setPaymentIds(paymentIds);
					return pushInfoVo;
				}
			}
		} catch (Exception e) {
			log.error("管理费明细推送失败:", e);
			return null;
		}
		return null;
	}

	private void copyManagerProperties(EkpIncomeParamRisk incomeParam, EkpRiskInfo riskInfoInfo) {
		//项目编码
		riskInfoInfo.setFd_3adfef5e5b9d34(incomeParam.getFd_3adfef5e5b9d34());
		//项目名称
		riskInfoInfo.setFd_3adfef5eb6691c(incomeParam.getFd_3adfef5eb6691c());
		//单号
		riskInfoInfo.setFd_3adfef7f5d2b52(incomeParam.getFd_3adfef7f5d2b52());
		//客户编码
		riskInfoInfo.setFd_3adfef80202ab2(incomeParam.getFd_3adfef80202ab2());
		//客户名称
		riskInfoInfo.setFd_3adfef7fc1c886(incomeParam.getFd_3adfef7fc1c886());
		//类型
		riskInfoInfo.setFd_3adda3037e3bda(incomeParam.getFd_3adda3037e3bda());
		//产生来源
		riskInfoInfo.setFd_3adda320daef5a(incomeParam.getFd_3adda320daef5a());
		//薪酬申请编号
		riskInfoInfo.setFd_3b3bf0c3198840(incomeParam.getFd_3b3bf0e75ef6c4());
		//姓名
		riskInfoInfo.setFd_3adfef948da848(incomeParam.getFd_3adfef948da848());
		//身份证号
		riskInfoInfo.setFd_3adfef94dcdbb4(incomeParam.getFd_3adfef94dcdbb4());
		//生成月份
		riskInfoInfo.setFd_3ae0c3032cffc8(incomeParam.getFd_3ae0c3032cffc8());
		//HRO结算月
		riskInfoInfo.setFd_3b13b2093b95ec(incomeParam.getFd_3ae0c3044e5958());
		//数据来源
		riskInfoInfo.setFd_3b0b7210ce9432("HRO");
		//风险金ID
		riskInfoInfo.setFd_3b13db120a8224(incomeParam.getFd_3b13dac4c03022());
		//管理费金额
		riskInfoInfo.setFd_3adfef963bae28(CommonConstants.EMPTY_STRING.equals(incomeParam.getFd_3adfef963bae28()) ? null : Double.parseDouble(incomeParam.getFd_3adfef963bae28()));
		//应收
		riskInfoInfo.setFd_3adfefa3daae72(CommonConstants.EMPTY_STRING.equals(incomeParam.getFd_3adfefa3daae72()) ? null : Double.parseDouble(incomeParam.getFd_3adfefa3daae72()));
		//结算状态
		riskInfoInfo.setFd_3adfefaaa3bbd0("未结算");
		//收款状态
		riskInfoInfo.setFd_3adfefaaef583e("未收");
		//单号
		riskInfoInfo.setFd_3adfef7f5d2b52("FXJ" + LocalDateTimeUtils.formatTime(LocalDateTime.now(), DateUtil.DATE_PATTERN)
				+ "_" + riskInfoInfo.getFd_3b13db120a8224());
	}
}
