/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 商险地市权限配置表
 *
 * @author fxj
 * @date 2022-11-01 10:32:05
 */
@Data
@TableName("t_insurance_area_res")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "商险地市权限配置表")
public class TInsuranceAreaRes extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 登录人id
	 */
	@ExcelAttribute(name = "登录人id", isNotEmpty = true, errorInfo = "登录人id不能为空", maxLength = 32)
	@NotBlank(message = "登录人id不能为空")
	@Length(max = 32, message = "登录人id不能超过32个字符")
	@ExcelProperty("登录人id")
	@Schema(description = "登录人id")
	private String userId;

	/**
	 * 登录人姓名
	 */
	@ExcelProperty("办理人")
	@Schema(description = "办理人")
	private String userName;
	/**
	 * 档案-省
	 */
	@ExcelAttribute(name = "档案-省",isArea = true, isNotEmpty = true, errorInfo = "档案-省不能为空")
	@NotBlank(message = "档案-省不能为空")
	@ExcelProperty("档案-省")
	@Schema(description = "档案-省")
	private String province;
	/**
	 * 档案-市
	 */
	@ExcelAttribute(name = "档案-市",isArea = true,parentField = "province")
	@ExcelProperty("档案-市")
	@Schema(description = "档案-市")
	private String city;


	/**
	 * 申請人所在部门
	 */
	@ExcelAttribute(name = "办理人所在部门")
	@ExcelProperty("办理人所在部门")
	@Schema(description = "办理人所在部门")
	private String organName;


	/**
	 * 状态  0 启用  1 禁用
	 */
	@ExcelAttribute(name = "状态")
	@ExcelProperty("状态")
	@Schema(description = "状态：0 启用  1 禁用")
	private String status;

}
