/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.social.entity.TAutoPaymentDetail;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.vo.TAutoPaymentDetailSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 自动化实缴记录表
 *
 * @author fxj
 * @date 2024-05-24 10:56:42
 */
public interface TAutoPaymentDetailService extends IService<TAutoPaymentDetail> {
	/**
	 * 自动化实缴记录表简单分页查询
	 *
	 * @param tAutoPaymentDetail 自动化实缴记录表
	 * @return
	 */
	IPage<TAutoPaymentDetail> getTAutoPaymentDetailPage(Page<TAutoPaymentDetail> page, TAutoPaymentDetailSearchVo tAutoPaymentDetail);

	R<List<ErrorMessage>> importDiy(InputStream inputStream,String parentId);

	void listExport(HttpServletResponse response, TAutoPaymentDetailSearchVo searchVo);

	List<TAutoPaymentDetail> noPageDiy(TAutoPaymentDetailSearchVo searchVo);

	/**
	 * @param: sourceType 资源类型：1日常申报导出；2人员缴费明细打印；3单位缴费明细查询；4单位缴费明细下载
	 * @Description: 清空明细表
	 * @Author: hgw
	 * @Date: 2024/6/6 9:54
	 * @return: void
	 **/
	void deleteByParentId(String parentId, int sourceType);

	/**
	 * @param parentId
	 * @Description: 获取被标记的明细，用来更新
	 * @Author: hgw
	 * @Date: 2024/6/7 17:50
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.social.entity.TAutoPaymentDetail>
	 **/
	List<TAutoPaymentDetail> getListByParentId(String parentId);

	/**
	 * @param parentId
	 * @Description: 获取被打标的条数，用作拦截重新办理
	 * @Author: hgw
	 * @Date: 2024/6/21 11:21
	 * @return: int
	 **/
	int getCountByParentId(String parentId);

}
