/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.write.style.ColumnWidth;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * HCM档案子Vo
 * @author hgw
 * @date 2023-11-23 12:02:03
 */
@Data
@ColumnWidth(30)
public class HcmArchiveBasicVo implements Serializable {

	private static final long serialVersionUID = 1L;

	@Schema(description = "员工姓名")
	private String empName;

	@Schema(description = "身份证号")
	private String empIdCard;

	@Schema(description = "邮箱")
	private String email;

	@Schema(description = "出生日期")
	private String bornDate;

	@Schema(description = "性别")
	private String sex;

	@Schema(description = "最高学历")
	private String education;
	// 户口性质
	@Schema(description = "户口类型")
	private String residentType;

	@Schema(description = "婚姻状况")
	private String maritalStatus;

	@Schema(description = "民族")
	private String nation;
	// 户籍所在地
	@Schema(description = "籍贯（省+市+区）")
	private String nativePlace;

	@Schema(description = "政治面貌")
	private String political;
	// 通讯地址
	@Schema(description = "联系地址（省+市+区+详细地址）")
	private String contactAddress;

	// 1.7.14新增推送字段
	@Schema(description = "手机号")
	private String empPhone;

	@Schema(description = "户籍所在地（省+市+区）")
	private String householdPlace;

	@Schema(description = "紧急联系人")
	private String emergencyContactName;

	@Schema(description = "紧急联系人与本人关系")
	private String emergencyContactRelation;

	@Schema(description = "紧急联系人电话")
	private String emergencyContactPhone;

	@Schema(description = "银行卡号")
	private String bankNo;

	@Schema(description = "开户行(总行)")
	private String bankName;

	@Schema(description = "社保户")
	private String socialHouseholdName;


	@Schema(description = "最高学历字典值")
	private String educationValue;
	// 户口性质
	@Schema(description = "户口类型字典值")
	private String residentTypeValue;

	@Schema(description = "婚姻状况字典值")
	private String maritalStatusValue;

	@Schema(description = "民族字典值")
	private String nationValue;

	@Schema(description = "政治面貌字典值")
	private String politicalValue;

	@Schema(description = "身份证-省")
	private Integer idProvince;

	@Schema(description = "身份证-市")
	private Integer idCity;

	@Schema(description = "身份证-县")
	private Integer idTown;

	@Schema(description = "通信地址省")
	private Integer contactProvince;

	@Schema(description = "通信地址市")
	private Integer contactCity;

	@Schema(description = "通信地址县")
	private Integer contactTown;


}
