/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 公积金购买规则明细表
 *
 * @author fxj
 * @date 2025-11-06 16:26:07
 */
@Data
public class TAutoFundRuleRelVo extends RowIndex implements Serializable {

	/**
	 * 主键ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键ID 不能为空")
	@Length(max = 32, message = "主键ID 不能超过32 个字符")
	@ExcelAttribute(name = "主键ID", isNotEmpty = true, errorInfo = "主键ID 不能为空", maxLength = 32)
	@Schema(description = "主键ID")
	@ExcelProperty("主键ID")
	private String id;
	/**
	 * 公积金配置ID
	 */
	@NotBlank(message = "公积金配置ID 不能为空")
	@Length(max = 32, message = "公积金配置ID 不能超过32 个字符")
	@ExcelAttribute(name = "公积金配置ID", isNotEmpty = true, errorInfo = "公积金配置ID 不能为空", maxLength = 32)
	@Schema(description = "公积金配置ID")
	@ExcelProperty("公积金配置ID")
	private String mainId;
	/**
	 * 配置名称
	 */
	@NotBlank(message = "配置名称 不能为空")
	@Length(max = 50, message = "配置名称 不能超过50 个字符")
	@ExcelAttribute(name = "配置名称", isNotEmpty = true, errorInfo = "配置名称 不能为空", maxLength = 50)
	@Schema(description = "配置名称")
	@ExcelProperty("配置名称")
	private String configName;
	/**
	 * 公积金户ID
	 */
	@Length(max = 50, message = "公积金户ID 不能超过50 个字符")
	@ExcelAttribute(name = "公积金户ID", maxLength = 50)
	@Schema(description = "公积金户ID")
	@ExcelProperty("公积金户ID")
	private String configHouseId;
	/**
	 * 公积金户名称
	 */
	@Length(max = 100, message = "公积金户名称 不能超过100 个字符")
	@ExcelAttribute(name = "公积金户名称", maxLength = 100)
	@Schema(description = "公积金户名称")
	@ExcelProperty("公积金户名称")
	private String configHouseName;
	/**
	 * 公积金单位个人比例是否一致(0-是,1-否)
	 */
	@Length(max = 1, message = "公积金单位个人比例是否一致(0-是,1-否) 不能超过1 个字符")
	@ExcelAttribute(name = "公积金单位个人比例是否一致(0-是,1-否)", maxLength = 1)
	@Schema(description = "公积金单位个人比例是否一致(0-是,1-否)")
	@ExcelProperty("公积金单位个人比例是否一致(0-是,1-否)")
	private String fundPerFlag;
	/**
	 * 起缴日期：0 入职日期
	 */
	@Length(max = 2, message = "起缴日期：0 入职日期 不能超过2 个字符")
	@ExcelAttribute(name = "起缴日期：0 入职日期", maxLength = 2)
	@Schema(description = "起缴日期：0 入职日期")
	@ExcelProperty("起缴日期：0 入职日期")
	private String fundDateType;
	/**
	 * 缴纳类型：0最低、1自定义、2最高、3固定基数
	 */
	@Length(max = 2, message = "缴纳类型：0最低、1自定义、2最高、3固定基数 不能超过2 个字符")
	@ExcelAttribute(name = "缴纳类型：0最低、1自定义、2最高、3固定基数", maxLength = 2)
	@Schema(description = "缴纳类型：0最低、1自定义、2最高、3固定基数")
	@ExcelProperty("缴纳类型：0最低、1自定义、2最高、3固定基数")
	private String paymentType;
	/**
	 * 公积金基数
	 */
	@ExcelAttribute(name = "公积金基数")
	@Schema(description = "公积金基数")
	@ExcelProperty("公积金基数")
	private BigDecimal fundBase;
	/**
	 * 公积金单位比例
	 */
	@Length(max = 30, message = "公积金单位比例 不能超过30 个字符")
	@ExcelAttribute(name = "公积金单位比例", maxLength = 30)
	@Schema(description = "公积金单位比例")
	@ExcelProperty("公积金单位比例")
	private String fundCompanyPer;
	/**
	 * 公积金个人比例
	 */
	@Length(max = 100, message = "公积金个人比例 不能超过100 个字符")
	@ExcelAttribute(name = "公积金个人比例", maxLength = 100)
	@Schema(description = "公积金个人比例")
	@ExcelProperty("公积金个人比例")
	private String fundPersonalPer;
	/**
	 * 项目编码
	 */
	@NotBlank(message = "项目编码 不能为空")
	@Length(max = 50, message = "项目编码 不能超过50 个字符")
	@ExcelAttribute(name = "项目编码", isNotEmpty = true, errorInfo = "项目编码 不能为空", maxLength = 50)
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String deptNo;
	/**
	 * 项目ID
	 */
	@NotBlank(message = "项目ID 不能为空")
	@Length(max = 50, message = "项目ID 不能超过50 个字符")
	@ExcelAttribute(name = "项目ID", isNotEmpty = true, errorInfo = "项目ID 不能为空", maxLength = 50)
	@Schema(description = "项目ID")
	@ExcelProperty("项目ID")
	private String deptId;

	/**
	 * 缴纳地-省（社保或公积金）
	 */
	@ExcelAttribute(name = "缴纳地-省（社保或公积金）")
	@Schema(description = "缴纳地-省（社保或公积金）")
	@ExcelProperty("缴纳地-省（社保或公积金）")
	private Integer province;
	/**
	 * 缴纳地-市（社保或公积金）
	 */
	@ExcelAttribute(name = "缴纳地-市（社保或公积金）")
	@Schema(description = "缴纳地-市（社保或公积金）")
	@ExcelProperty("缴纳地-市（社保或公积金）")
	private Integer city;
	/**
	 * 缴纳地-县（社保或公积金）
	 */
	@ExcelAttribute(name = "缴纳地-县（社保或公积金）")
	@Schema(description = "缴纳地-县（社保或公积金）")
	@ExcelProperty("缴纳地-县（社保或公积金）")
	private Integer town;
	/**
	 * 基数上限（社保或公积金）
	 */
	@ExcelAttribute(name = "基数上限（社保或公积金）")
	@Schema(description = "基数上限（社保或公积金）")
	@ExcelProperty("基数上限（社保或公积金）")
	private BigDecimal upperLimit;
	/**
	 * 基数下限（社保或公积金）
	 */
	@ExcelAttribute(name = "基数下限（社保或公积金）")
	@Schema(description = "基数下限（社保或公积金）")
	@ExcelProperty("基数下限（社保或公积金）")
	private BigDecimal lowerLimit;

}
