package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractPre;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 合同待签订任务记录表
 *
 * @author huych
 * @date 2025-06-11 14:15:53
 */
@Data
public class TEmployeeContractPreSearchVo extends TEmployeeContractPre {

	/**
	 * 多选导出或删除等操作
	 */
	@Schema(description = "选中ID,id数组")
	private List<String> idList;
	/**
	 * @Author fxj
	 * 查询数据起
	 **/
	@Schema(description = "查询limit  开始")
	private int limitStart;
	/**
	 * @Author fxj
	 * 查询数据止
	 **/
	@Schema(description = "查询limit  数据条数")
	private int limitEnd;

	//开始时间（查询专用）
	@Schema(description =  "入离职开始时间")
	@TableField(exist = false)
	private LocalDateTime joinTimeStart;

	//截止时间（查询专用）
	@Schema(description =  "入离职截止时间")
	@TableField(exist = false)
	private LocalDateTime joinTimeEnd;

	@Schema(description =  "处理状态数组")
	@TableField(exist = false)
	private List<String> statusList;

	@Schema(description =  "项目权限数组")
	@TableField(exist = false)
	private List<String> deptNoList;

	@Schema(description =  "列表类型 1 待办 2监控")
	private String type;

	@Schema(description =  "自动标识 1不查询确认时间为空的数据")
	private String autoSendFlag;

}
