/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.Data;

import java.io.Serializable;

/**
 * 瓜子档案表——导出工作经历
 *
 * @author hgw
 * @date 2025-6-19 15:09:18
 */
@Data
@ColumnWidth(15)
public class TGzEmpInfoExportWork implements Serializable {

	// 流程ID	姓名	证件号码	单位名称	开始日期	结束日期	所在部门	职务名称	证明人	证明人联系电话
	@ExcelProperty("流程ID")
	private String bizId;
	@ExcelProperty("姓名")
	private String name;
	@ExcelProperty("证件号码")
	private String nationalId;

	@ExcelProperty("单位名称")
	private String workUnit;

	// 日期格式化
	@ExcelProperty("开始日期")
	private String workStartDate;
	// 日期格式化
	@ExcelProperty("结束日期")
	private String workEndDate;
	@ExcelProperty("所在部门")
	private String workDept;
	@ExcelProperty("职务名称")
	private String workJob;
	@ExcelProperty("证明人")
	private String certifierName;
	@ExcelProperty("证明人联系电话")
	private String certifierPhone;

}
