package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.EmployeeRegistrationPre;
import com.yifu.cloud.plus.v1.yifu.archives.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 入职待建档表
 *
 * @author huych
 * @date 2025-03-12 17:14:19
 */
@Mapper
public interface EmployeeRegistrationPreMapper extends BaseMapper<EmployeeRegistrationPre> {
    /**
     * 入职待建档表简单分页查询
     * @param employeeRegistrationPre 入职待建档表
     * @return
     */
    IPage<EmployeeRegistrationPre> getEmployeeRegistrationPrePage(Page<EmployeeRegistrationPre> page, @Param("employeeRegistrationPre") EmployeeRegistrationPre employeeRegistrationPre);
	/**
	 * 入职待建档表导出数量查询
	 * @param searchVo 导出查询vo
	 * @return
	 */
	long selectExportCount(@Param("employeeRegistrationPre") EmployeeRegistrationPreSearchVo searchVo);
	/**
	 * 入职待建档表导出列表查询
	 * @param searchVo 导出查询vo
	 * @return
	 */
	List<EmployeeRegistrationPreExportVo> selectExportList(@Param("employeeRegistrationPre") EmployeeRegistrationPreSearchVo searchVo);

	/**
	 * 入职确认信息导出列表查询
	 * @param searchVo 导出查询vo
	 * @return
	 */
	List<EmployeeRegistrationPreInfoExportVo> selectConfirmExportList(@Param("employeeRegistrationPre") EmployeeRegistrationPreSearchVo searchVo);

	MessageTempleteVo selectTempleteVo(@Param("id") String id);

	EmployeeInfoMsgVo getEmployeeArchivesInfo(@Param("id") String id,@Param("typeList") List<String> type);

	/**
	 * @Description: 判断简档详档-优先从档案维护任务表
	 * @Author: hgw
	 * @Date: 2025/3/20 15:20
	 * @return: java.lang.String
	 **/
	String judegIsSimpleByPre(@Param("empIdCard") String empIdCard, @Param("deptId") String deptId);
	/**
	 * @Description: 获取员工类型与档案地市 -优先从档案维护任务表
	 * @Author: hgw
	 * @Date: 2025/3/21 11:25
	 * @return: com.yifu.cloud.plus.v1.yifu.archives.entity.EmployeeRegistrationPre
	 **/
	EmployeeRegistrationPre getPreByPre(@Param("empIdCard") String empIdCard, @Param("deptId") String deptId);

	/**
	 * @Description: 判断简档详档-从项目档案表
	 * @Author: hgw
	 * @Date: 2025/3/20 15:20
	 * @return: java.lang.String
	 **/
	String judegIsSimpleByEmpProject(@Param("empIdCard") String empIdCard, @Param("deptId") String deptId);
	/**
	 * @Description: 获取员工类型与档案地市 从项目档案表
	 * @Author: hgw
	 * @Date: 2025/3/21 11:25
	 * @return: com.yifu.cloud.plus.v1.yifu.archives.entity.EmployeeRegistrationPre
	 **/
	EmployeeRegistrationPre getPreByEmpProject(@Param("empIdCard") String empIdCard, @Param("deptId") String deptId);

}
