/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoFundRuleRel;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoFundRuleRelSearchVo;

import java.util.List;

/**
 * 公积金购买规则明细表
 *
 * @author fxj
 * @date 2025-11-06 16:26:07
 */
public interface TAutoFundRuleRelService extends IService<TAutoFundRuleRel> {
	/**
	 * 社保购买规则明细表简单分页查询
	 *
	 * @param tAutoFundRuleRel 社保购买规则明细表
	 * @return
	 */
	IPage<TAutoFundRuleRel> getTAutoFundRuleRelPage(Page<TAutoFundRuleRel> page, TAutoFundRuleRelSearchVo tAutoFundRuleRel);

	List<TAutoFundRuleRel> noPageDiy(TAutoFundRuleRelSearchVo searchVo);
}
