/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 商险续签待办
 *
 * @author hgw
 * @date 2025-11-11 16:33:49
 */
@Data
@TableName("t_insurance_pre_renew_detail")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "商险续签待办")
public class TInsurancePreRenewDetail extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 商险ID
	 */
	@ExcelAttribute(name = "商险ID", isNotEmpty = true, errorInfo = "商险ID不能为空", maxLength = 32)
	@NotBlank(message = "商险ID不能为空")
	@Length(max = 32, message = "商险ID不能超过32个字符")
	@ExcelProperty("商险ID")
	@Schema(description = "商险ID")
	private String insurancesId;
	/**
	 * 结算主体名称
	 */
	@ExcelAttribute(name = "结算主体名称", maxLength = 50)
	@Length(max = 50, message = "结算主体名称不能超过50个字符")
	@ExcelProperty("结算主体名称")
	@Schema(description = "结算主体名称")
	private String deptName;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", maxLength = 30)
	@Length(max = 30, message = "项目编码不能超过30个字符")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String deptNo;
	/**
	 * 姓名
	 */
	@ExcelAttribute(name = "姓名", maxLength = 32)
	@Length(max = 32, message = "姓名不能超过32个字符")
	@ExcelProperty("姓名")
	@Schema(description = "姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, errorInfo = "身份证号不能为空", maxLength = 32)
	@NotBlank(message = "身份证号不能为空")
	@Length(max = 32, message = "身份证号不能超过32个字符")
	@ExcelProperty("身份证号")
	@Schema(description = "身份证号")
	private String empIdcardNo;
	/**
	 * 岗位
	 */
	@ExcelAttribute(name = "岗位", maxLength = 32)
	@Length(max = 32, message = "岗位不能超过32个字符")
	@ExcelProperty("岗位")
	@Schema(description = "岗位")
	private String post;
	/**
	 * 原购买类型， 1新增、3批增、4替换
	 */
	@ExcelAttribute(name = "原购买类型， 1新增、3批增、4替换")
	@ExcelProperty("原购买类型， 1新增、3批增、4替换")
	@Schema(description = "原购买类型， 1新增、3批增、4替换")
	private Integer buyTypeOld;
	/**
	 * 原商险购买地省
	 */
	@ExcelAttribute(name = "原商险购买地省", maxLength = 32)
	@Length(max = 32, message = "原商险购买地省不能超过32个字符")
	@ExcelProperty("原商险购买地省")
	@Schema(description = "原商险购买地省")
	private String insuranceProvinceNameOld;
	/**
	 * 原商险购买地市
	 */
	@ExcelAttribute(name = "原商险购买地市", maxLength = 32)
	@Length(max = 32, message = "原商险购买地市不能超过32个字符")
	@ExcelProperty("原商险购买地市")
	@Schema(description = "原商险购买地市")
	private String insuranceCityNameOld;
	/**
	 * 原保险公司名称
	 */
	@ExcelAttribute(name = "原保险公司名称", maxLength = 60)
	@Length(max = 60, message = "原保险公司名称不能超过60个字符")
	@ExcelProperty("原保险公司名称")
	@Schema(description = "原保险公司名称")
	private String insuranceCompanyNameOld;
	/**
	 * 原险种名称
	 */
	@ExcelAttribute(name = "原险种名称", maxLength = 50)
	@Length(max = 50, message = "原险种名称不能超过50个字符")
	@ExcelProperty("原险种名称")
	@Schema(description = "原险种名称")
	private String insuranceTypeNameOld;
	/**
	 * 原保单生效日期
	 */
	@ExcelAttribute(name = "原保单生效日期", isDate = true)
	@ExcelProperty("原保单生效日期")
	@Schema(description = "原保单生效日期")
	private LocalDate policyEffectOld;
	/**
	 * 原保单开始时间
	 */
	@ExcelAttribute(name = "原保单开始时间", isDate = true)
	@ExcelProperty("原保单开始时间")
	@Schema(description = "原保单开始时间")
	private LocalDate policyStartOld;
	/**
	 * 原保单结束时间
	 */
	@ExcelAttribute(name = "原保单结束时间", isDate = true)
	@ExcelProperty("原保单结束时间")
	@Schema(description = "原保单结束时间")
	private LocalDate policyEndOld;
	/**
	 * 投保类型： 1新增、3批增、4替换
	 */
	@ExcelAttribute(name = "投保类型： 1新增、3批增、4替换")
	@ExcelProperty("投保类型： 1新增、3批增、4替换")
	@Schema(description = "投保类型： 1新增、3批增、4替换")
	private Integer buyType;
	/**
	 * 配置id
	 */
	@ExcelAttribute(name = "配置id", maxLength = 36)
	@Length(max = 36, message = "配置id不能超过36个字符")
	@ExcelProperty("配置id")
	@Schema(description = "配置id")
	private String configId;
	/**
	 * 配置名称
	 */
	@ExcelAttribute(name = "配置名称", maxLength = 50)
	@Length(max = 50, message = "配置名称不能超过50个字符")
	@ExcelProperty("配置名称")
	@Schema(description = "配置名称")
	private String configName;
	/**
	 * 保险公司名称
	 */
	@ExcelAttribute(name = "保险公司名称", maxLength = 60)
	@Length(max = 60, message = "保险公司名称不能超过60个字符")
	@ExcelProperty("保险公司名称")
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;
	/**
	 * 险种名称
	 */
	@ExcelAttribute(name = "险种名称", maxLength = 50)
	@Length(max = 50, message = "险种名称不能超过50个字符")
	@ExcelProperty("险种名称")
	@Schema(description = "险种名称")
	private String insuranceTypeName;
	/**
	 * 购买标准
	 */
	@ExcelAttribute(name = "购买标准", maxLength = 32)
	@Length(max = 32, message = "购买标准不能超过32个字符")
	@ExcelProperty("购买标准")
	@Schema(description = "购买标准")
	private String buyStandard;
	/**
	 * 商险购买地省
	 */
	@ExcelAttribute(name = "商险购买地省", maxLength = 32)
	@Length(max = 32, message = "商险购买地省不能超过32个字符")
	@ExcelProperty("商险购买地省")
	@Schema(description = "商险购买地省")
	private String insuranceProvinceName;
	/**
	 * 商险购买地市
	 */
	@ExcelAttribute(name = "商险购买地市", maxLength = 32)
	@Length(max = 32, message = "商险购买地市不能超过32个字符")
	@ExcelProperty("商险购买地市")
	@Schema(description = "商险购买地市")
	private String insuranceCityName;
	/**
	 * 保单开始时间
	 */
	@ExcelAttribute(name = "保单开始时间", isDate = true)
	@ExcelProperty("保单开始时间")
	@Schema(description = "保单开始时间")
	private LocalDate policyStart;
	/**
	 * 保单结束时间
	 */
	@ExcelAttribute(name = "保单结束时间", isDate = true)
	@ExcelProperty("保单结束时间")
	@Schema(description = "保单结束时间")
	private LocalDate policyEnd;
	/**
	 * 预计保单生效日期
	 */
	@ExcelAttribute(name = "预计保单生效日期", isDate = true)
	@ExcelProperty("预计保单生效日期")
	@Schema(description = "预计保单生效日期")
	private LocalDate policyEffect;

	/**
	 * 预计派单时间
	 */
	//@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@ExcelAttribute(name = "预计派单时间", isDate = true)
	@ExcelProperty("预计派单时间")
	@Schema(description = "预计派单时间")
	private LocalDateTime expectedCollectionTime;
	/**
	 * 客户名称
	 */
	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Length(max = 50, message = "客户名称不能超过50个字符")
	@ExcelProperty("客户名称")
	@Schema(description = "客户名称")
	private String unitName;
	/**
	 * 客户编码
	 */
	@ExcelAttribute(name = "客户编码", maxLength = 32)
	@Length(max = 32, message = "客户编码不能超过32个字符")
	@ExcelProperty("客户编码")
	@Schema(description = "客户编码")
	private String unitNo;
	/**
	 * 是否地市自购0是 1 否
	 */
	@ExcelAttribute(name = "是否地市自购0是 1 否", maxLength = 1)
	@Length(max = 1, message = "是否地市自购0是 1 否不能超过1个字符")
	@ExcelProperty("是否地市自购0是 1 否")
	@Schema(description = "是否地市自购0是 1 否")
	private String isAdress;
	/**
	 * 失败原因
	 */
	@ExcelAttribute(name = "失败原因", maxLength = 200)
	@Length(max = 200, message = "失败原因不能超过200个字符")
	@ExcelProperty("失败原因")
	@Schema(description = "失败原因")
	private String errorInfo;
	/**
	 * 失败时间
	 */
	@ExcelAttribute(name = "失败时间", isDate = true)
	@ExcelProperty("失败时间")
	@Schema(description = "失败时间")
	private LocalDateTime errorTime;
	/**
	 * 保单号
	 */
	@ExcelAttribute(name = "保单号", maxLength = 50)
	@Length(max = 50, message = "保单号不能超过50个字符")
	@ExcelProperty("保单号")
	@Schema(description = "保单号")
	private String policyNo;
	/**
	 * 替换员工姓名
	 */
	@ExcelAttribute(name = "替换员工姓名", maxLength = 30)
	@Length(max = 30, message = "替换员工姓名不能超过30个字符")
	@ExcelProperty("替换员工姓名")
	@Schema(description = "替换员工姓名")
	private String replaceEmployeeName;
	/**
	 * 替换身份证号
	 */
	@ExcelAttribute(name = "替换身份证号", maxLength = 18)
	@Length(max = 18, message = "替换身份证号不能超过18个字符")
	@ExcelProperty("替换身份证号")
	@Schema(description = "替换身份证号")
	private String replaceEmpIdcard;
	/**
	 * 替换项目编码
	 */
	@ExcelAttribute(name = "替换项目编码", maxLength = 30)
	@Length(max = 30, message = "替换项目编码不能超过30个字符")
	@ExcelProperty("替换项目编码")
	@Schema(description = "替换项目编码")
	private String replaceDeptNo;
	/**
	 * 状态,0待确认,1待派单,2派单失败,3待投保,4投保中,5投保退回,6已投保
	 */
	@ExcelAttribute(name = "状态,0待确认,1待派单,2派单失败,3待投保,4投保中,5投保退回,6已投保", maxLength = 1)
	@Length(max = 1, message = "状态,0待确认,1待派单,2派单失败,3待投保,4投保中,5投保退回,6已投保不能超过1个字符")
	@ExcelProperty("状态,0待确认,1待派单,2派单失败,3待投保,4投保中,5投保退回,6已投保")
	@Schema(description = "状态,0待确认,1待派单,2派单失败,3待投保,4投保中,5投保退回,6已投保")
	private String processStatus;

}
