/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.insurances.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsurancePreRenewDetail;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsurancePreRenewDetailService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;


/**
 * 商险续签待办
 *
 * @author hgw
 * @date 2025-11-11 16:33:49
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tinsuranceprerenewdetail")
@Tag(name = "商险续签待办管理")
public class TInsurancePreRenewDetailController {

	private final TInsurancePreRenewDetailService tInsurancePreRenewDetailService;


	/**
	 * 简单分页查询
	 *
	 * @param page                     分页对象
	 * @param tInsurancePreRenewDetail 商险续签待办
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TInsurancePreRenewDetail>> getTInsurancePreRenewDetailPage(Page<TInsurancePreRenewDetail> page, TInsurancePreRenewDetail tInsurancePreRenewDetail) {
		return new R<>(tInsurancePreRenewDetailService.getTInsurancePreRenewDetailPage(page, tInsurancePreRenewDetail));
	}

	/**
	 * 通过insurancesId查询商险续签待办
	 *
	 * @return R
	 */
	@Operation(summary = "通过insurancesId查询", description = "通过insurancesId查询")
	@GetMapping("/getByInsurancesId")
	public R<TInsurancePreRenewDetail> getByInsurancesId(@RequestParam String insurancesId) {
		TInsurancePreRenewDetail tInsurancePreRenewDetail = tInsurancePreRenewDetailService
				.getOne(Wrappers.<TInsurancePreRenewDetail>lambdaQuery()
						.eq(TInsurancePreRenewDetail::getInsurancesId, insurancesId)
						.last(CommonConstants.LAST_ONE_SQL));
		return R.ok(tInsurancePreRenewDetail);
	}

	/**
	 * 修改商险续签待办
	 *
	 * @param tInsurancePreRenewDetail 商险续签待办
	 * @return R
	 */
	@Operation(summary = "单个确认-商险续签待办", description = "单个确认-商险续签待办")
	@SysLog("单个确认-商险续签待办")
	@PostMapping("/doSure")
	public R<Boolean> doSure(@RequestBody TInsurancePreRenewDetail tInsurancePreRenewDetail) {
		if (tInsurancePreRenewDetail != null && Common.isNotNull(tInsurancePreRenewDetail.getId())) {
			TInsurancePreRenewDetail old = tInsurancePreRenewDetailService.getById(tInsurancePreRenewDetail.getId());
			if (old == null || Common.isEmpty(old.getId()) || Common.isEmpty(old.getProcessStatus())) {
				return R.failed("根据ID未找到续签待办信息");
			}
			if (!CommonConstants.ZERO_STRING.equals(old.getProcessStatus())) {
				return R.failed("状态非待确认，请检查");
			}
		} else {
			return R.failed("请传参ID");
		}
		tInsurancePreRenewDetail.setProcessStatus(CommonConstants.ONE_STRING);
		return R.ok(tInsurancePreRenewDetailService.updateById(tInsurancePreRenewDetail));
	}

	/**
	 * 修改商险续签待办
	 *
	 * @param tInsurancePreRenewDetail 商险续签待办
	 * @return R
	 */
	@Operation(summary = "编辑商险续签待办", description = "编辑商险续签待办")
	@SysLog("编辑商险续签待办")
	@PutMapping
	public R<Boolean> updateById(@RequestBody TInsurancePreRenewDetail tInsurancePreRenewDetail) {
		if (tInsurancePreRenewDetail != null && Common.isNotNull(tInsurancePreRenewDetail.getId())) {
			TInsurancePreRenewDetail old = tInsurancePreRenewDetailService.getById(tInsurancePreRenewDetail.getId());
			if (old == null || Common.isEmpty(old.getId()) || Common.isEmpty(old.getProcessStatus())) {
				return R.failed("根据ID未找到续签待办信息");
			}
			if (!(CommonConstants.ONE_STRING.equals(old.getProcessStatus())
					|| CommonConstants.TWO_STRING.equals(old.getProcessStatus())
					|| CommonConstants.FIVE_STRING.equals(old.getProcessStatus()))) {
				return R.failed("该状态不可编辑，请刷新后重试");
			}
			if (Common.isNotNull(tInsurancePreRenewDetail.getProcessStatus())
					&& !old.getProcessStatus().equals(tInsurancePreRenewDetail.getProcessStatus())) {
				return R.failed("状态在编辑保存前发生改变，请刷新后重试");
			}
		} else {
			return R.failed("请传参ID");
		}
		return R.ok(tInsurancePreRenewDetailService.updateById(tInsurancePreRenewDetail));
	}

}
