/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.MenuUtil;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TDeptSee;
import com.yifu.cloud.plus.v1.yifu.salary.service.TDeptSeeService;
import com.yifu.cloud.plus.v1.yifu.salary.util.SalaryConstants;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TDeptSeeSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 项目薪资查询权限配置表-薪资配置1
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tdeptsee")
@Tag(name = "项目薪资查询权限配置表-薪资配置1管理")
public class TDeptSeeController {

	private final TDeptSeeService tDeptSeeService;

	private final MenuUtil menuUtil;
	/**
	 * 简单分页查询
	 *
	 * @param page     分页对象
	 * @param tDeptSee 项目薪资查询权限配置表-薪资配置1
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TDeptSee>> getTDeptSeePage(Page<TDeptSee> page, TDeptSeeSearchVo tDeptSee) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, tDeptSee);
		if (Common.isNotNull(tDeptSee.getAuthSql()) && tDeptSee.getAuthSql().contains(CommonConstants.A_DEPT_ID)) {
			tDeptSee.setAuthSql(tDeptSee.getAuthSql().replace(CommonConstants.A_DEPT_ID, "a.ID"));
		}
		return new R<>(tDeptSeeService.getTDeptSeePage(page, tDeptSee));
	}

	/**
	 * 不分页查询
	 *
	 * @param tDeptSee 项目薪资查询权限配置表-薪资配置1
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	//@PreAuthorize("@pms.hasPermission('salary_tdeptsee_get')" )
	public R<List<TDeptSee>> getTDeptSeeNoPage(@RequestBody TDeptSeeSearchVo tDeptSee) {
		return R.ok(tDeptSeeService.noPageDiy(tDeptSee));
	}

	/**
	 * 通过id查询项目薪资查询权限配置表-薪资配置1
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询")
	@GetMapping("/{id}")
	public R<TDeptSee> getById(@PathVariable("id") String id) {
		return R.ok(tDeptSeeService.getById(id));
	}

	/**
	 * 新增项目薪资查询权限配置表-薪资配置1
	 *
	 * @param tDeptSee 项目薪资查询权限配置表-薪资配置1
	 * @return R
	 */
	@Operation(summary = "新增项目薪资查询权限配置表-薪资配置1", description = "新增项目薪资查询权限配置表-薪资配置1：hasPermission('salary_tdeptsee_add')")
	@SysLog("新增项目薪资查询权限配置表-薪资配置1")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('salary_tdeptsee_add')")
	public R<Boolean> save(@RequestBody TDeptSee tDeptSee) {
		long res = tDeptSeeService.count(Wrappers.<TDeptSee>query().lambda().eq(TDeptSee::getId,tDeptSee.getId()));
		if (res > 0){
			return R.failed(SalaryConstants.DEPT_SEE_REPEAT);
		}
		return R.ok(tDeptSeeService.save(tDeptSee));
	}

	/**
	 * 修改项目薪资查询权限配置表-薪资配置1
	 *
	 * @param tDeptSee 项目薪资查询权限配置表-薪资配置1
	 * @return R
	 */
	@Operation(summary = "修改项目薪资查询权限配置表-薪资配置1", description = "修改项目薪资查询权限配置表-薪资配置1：hasPermission('salary_tdeptsee_edit')")
	@SysLog("修改项目薪资查询权限配置表-薪资配置1")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('salary_tdeptsee_edit')")
	public R<Boolean> updateById(@RequestBody TDeptSee tDeptSee) {
		return R.ok(tDeptSeeService.updateById(tDeptSee));
	}

	/**
	 * 通过id删除项目薪资查询权限配置表-薪资配置1
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除项目薪资查询权限配置表-薪资配置1", description = "通过id删除项目薪资查询权限配置表-薪资配置1：hasPermission('salary_tdeptsee_del')")
	@SysLog("通过id删除项目薪资查询权限配置表-薪资配置1")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('salary_tdeptsee_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		return R.ok(tDeptSeeService.removeById(id));
	}

}
