/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.HolidayListVO;
import com.yifu.cloud.plus.v1.yifu.social.entity.THolidayInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TEmployeeInsuranceWorkDayVo;
import com.yifu.cloud.plus.v1.yifu.social.vo.THolidayInfoSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * @author fxj
 * @date 2024-05-08 11:52:08
 */
public interface THolidayInfoService extends IService<THolidayInfo> {
	/**
	 * 简单分页查询
	 *
	 * @param tHolidayInfo
	 * @return
	 */
	IPage<THolidayInfo> getTHolidayInfoPage(Page<THolidayInfo> page, THolidayInfoSearchVo tHolidayInfo);

	R<List<ErrorMessage>> importDiy(InputStream inputStream);

	void listExport(HttpServletResponse response, THolidayInfoSearchVo searchVo);

	List<THolidayInfo> noPageDiy(THolidayInfoSearchVo searchVo);

	void createHolidayInfo();

	TEmployeeInsuranceWorkDayVo getInitBeforeOrAfterWorkDay(TEmployeeInsuranceWorkDayVo vo);

	TEmployeeInsuranceWorkDayVo selectBeforeOrAfterWorkDay(TEmployeeInsuranceWorkDayVo vo);

	TEmployeeInsuranceWorkDayVo selectBeforeOrAfterWorkDayCommon(TEmployeeInsuranceWorkDayVo vo);

	Boolean checkIsWorkDay(TEmployeeInsuranceWorkDayVo vo);

	/**
	 * @Description: 最近一个月（“当前时间（含）” 到 “当前时间+1个月”）的工作日Map
	 * 	// 例如，当前时间是2025-11-11，周二，15号，16号是节假日（周六周日）：返回：
	 * 	2025-11-11,1（周二，当天为1）
	 * 	2025-11-12,2
	 * 	2025-11-13,3
	 * 	2025-11-14,4（周五）
	 * 	2025-11-15,4（周六）
	 * 	2025-11-16,4（周日）
	 * 	2025-11-17,5
	 * @Author: hgw
	 * @Date: 2025/11/11 10:46
	 * @return: com.yifu.cloud.plus.v1.yifu.insurances.vo.HolidayListVO
	 **/
	HolidayListVO getOneMonthDay();
}
