package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yifu.cloud.plus.v1.yifu.archives.entity.LUnitInfoForProve;
import com.yifu.cloud.plus.v1.yifu.archives.service.LUnitInfoForProveService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * @author pwang
 * @date 2019-11-05 15:24:25
 */
@RestController
@AllArgsConstructor
@RequestMapping("/lunitinfoforprove")
@Tag(name = "工资证明操作数据")
public class LUnitInfoForProveController {

	private final LUnitInfoForProveService lUnitInfoForProveService;

	/**
	 * 简单分页查询
	 * 获取用户自己的操作数据
	 *
	 * @return
	 */
	@Operation(summary = "获取用户自己的操作数据")
	@GetMapping("/ownList")
	public R<List<LUnitInfoForProve>> getownList() {
		YifuUser user = SecurityUtils.getUser();
		return new R<>(lUnitInfoForProveService.list(Wrappers.<LUnitInfoForProve>lambdaQuery().eq(LUnitInfoForProve::getCreatUser, user.getId())));
	}

}
