/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoInsurRuleInfo;
import com.yifu.cloud.plus.v1.yifu.archives.service.TAutoInsurRuleInfoService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoInsurRuleInfoSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 商险购买规则配置表
 *
 * @author fxj
 * @date 2025-04-01 10:14:09
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tautoinsurruleinfo" )
@Tag(name = "商险购买规则配置表管理")
public class TAutoInsurRuleInfoController {

    private final  TAutoInsurRuleInfoService tAutoInsurRuleInfoService;

    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tAutoInsurRuleInfo 商险购买规则配置表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TAutoInsurRuleInfo>> getTAutoInsurRuleInfoPage(Page<TAutoInsurRuleInfo> page, TAutoInsurRuleInfoSearchVo tAutoInsurRuleInfo) {
        return  new R<>(tAutoInsurRuleInfoService.getTAutoInsurRuleInfoPage(page,tAutoInsurRuleInfo));
    }
    /**
     * 不分页查询
     * @param tAutoInsurRuleInfo 商险购买规则配置表
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    //@PreAuthorize("@pms.hasPermission('demo_tautoinsurruleinfo_get')" )
    public R<List<TAutoInsurRuleInfo>> getTAutoInsurRuleInfoNoPage(@RequestBody TAutoInsurRuleInfoSearchVo tAutoInsurRuleInfo) {
        return R.ok(tAutoInsurRuleInfoService.noPageDiy(tAutoInsurRuleInfo));
    }

    /**
     * 通过id查询商险购买规则配置表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('demo_tautoinsurruleinfo_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tautoinsurruleinfo_get')" )
    public R<TAutoInsurRuleInfo> getById(@PathVariable("id" ) String id) {
        return R.ok(tAutoInsurRuleInfoService.getById(id));
    }

    /**
     * 新增商险购买规则配置表
     * @param tAutoInsurRuleInfo 商险购买规则配置表
     * @return R
     */
    @Operation(summary = "新增商险购买规则配置表", description = "新增商险购买规则配置表：hasPermission('demo_tautoinsurruleinfo_add')")
    @SysLog("新增商险购买规则配置表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('demo_tautoinsurruleinfo_add')" )
    public R<Boolean> save(@RequestBody TAutoInsurRuleInfo tAutoInsurRuleInfo) {
        return R.ok(tAutoInsurRuleInfoService.save(tAutoInsurRuleInfo));
    }

    /**
     * 修改商险购买规则配置表
     * @param tAutoInsurRuleInfo 商险购买规则配置表
     * @return R
     */
    @Operation(summary = "修改商险购买规则配置表", description = "修改商险购买规则配置表：hasPermission('demo_tautoinsurruleinfo_edit')")
    @SysLog("修改商险购买规则配置表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('demo_tautoinsurruleinfo_edit')" )
    public R<Boolean> updateById(@RequestBody TAutoInsurRuleInfo tAutoInsurRuleInfo) {
        return R.ok(tAutoInsurRuleInfoService.updateById(tAutoInsurRuleInfo));
    }

    /**
     * 通过id删除商险购买规则配置表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除商险购买规则配置表", description = "通过id删除商险购买规则配置表：hasPermission('demo_tautoinsurruleinfo_del')")
    @SysLog("通过id删除商险购买规则配置表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tautoinsurruleinfo_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tAutoInsurRuleInfoService.removeById(id));
    }

    /**
	 * 商险购买规则配置表 批量导入
	 *
     * @author fxj
     * @date 2025-04-01 10:14:09
	 **/
    @SneakyThrows
    @Operation(description = "批量新增商险购买规则配置表 hasPermission('demo_tautoinsurruleinfo-batch-import')")
    @SysLog("批量新增商险购买规则配置表")
    @PostMapping("/importListAdd")
    @PreAuthorize("@pms.hasPermission('demo_tautoinsurruleinfo-batch-import')")
    public R<List<ErrorMessage>> importListAdd(@RequestBody MultipartFile file){
        return tAutoInsurRuleInfoService.importDiy(file.getInputStream());
    }

    /**
     * 商险购买规则配置表 批量导出
     * @author fxj
     * @date 2025-04-01 10:14:09
     **/
    @Operation(description = "导出商险购买规则配置表 hasPermission('demo_tautoinsurruleinfo-export')")
    @PostMapping("/export")
    @PreAuthorize("@pms.hasPermission('demo_tautoinsurruleinfo-export')")
    public void export(HttpServletResponse response, @RequestBody TAutoInsurRuleInfoSearchVo searchVo) {
            tAutoInsurRuleInfoService.listExport(response,searchVo);
    }
}
