package com.yifu.cloud.plus.v1.business.vo.vacation;


import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @description: 假期监控清零日志表 分页查询展示 vo
 * @author: wangweiguo
 * @date: 2021-08-16
*/
@Setter
@Getter
@ToString
public class TVacationMonitorClearLogVO implements Serializable {

    /**
     * 主键
     */
	@Schema(description = "主键")
    private String id;

    /**
     * 清零说明
     */
	@Schema(description = "清零说明")
	private String clearNote;

    /**
     * 清零时长
     */
	@Schema(description = "清零时长")
	private BigDecimal clearDuration;

    /**
     * 年份
     */
	@Schema(description = "年份")
	private String vacationYear;

    /**
     * 清零人姓名
     */
	@Schema(description = "清零人姓名")
	private String clearUser;

    /**
     * 清零时间
     */
	@Schema(description = "清零时间")
	private LocalDateTime clearTime;

    private static final long serialVersionUID = 1L;

}

