/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.common.core.vo;

import lombok.Data;

import java.io.Serializable;

/**
 * 封装更多信息-返回给前端的错误信息
 *
 * @author hgw
 * @date 2022-11-24 16:41:21
 */
@Data
public class ErrorDetailVO implements Serializable {

	private static final long serialVersionUID = 1L;

	// 行号
	private int lineNum;

	// 员工姓名
	private String empName;

	// 身份证号
	private String empIdCard;

	// 社保户
	private String socialHousehold;
	// 公积金户
	private String providentHousehold;

	// 每一行的结果：0错误；1正确（例如：是否允许删除：0否；1是）
	private int result = 0;

	// 提示信息
	private String message;
	// 颜色
	private String color = "red";

	// 所有行的结果，当第一行的allTrue=1时，需要反馈文件，否则直接提示成功
	private int allTrue = 0;

	public ErrorDetailVO(Integer lineNum, String message) {
		this.lineNum = lineNum;
		this.result = 0;
		this.message = message;
	}

	public ErrorDetailVO(Integer lineNum, int result, String empIdCard, String socialHousehold, String providentHousehold, String empName,String message) {
		this.lineNum = lineNum;
		this.result = result;
		this.empIdCard = empIdCard;
		this.socialHousehold = socialHousehold;
		this.providentHousehold = providentHousehold;
		this.empName = empName;
		this.message = message;
	}

	public ErrorDetailVO(Integer lineNum, int result, String empIdCard, String socialHousehold, String providentHousehold, String empName,String message,String color) {
		this.lineNum = lineNum;
		this.result = result;
		this.empIdCard = empIdCard;
		this.socialHousehold = socialHousehold;
		this.providentHousehold = providentHousehold;
		this.empName = empName;
		this.message = message;
		this.color = color;
	}

}
