package com.yifu.cloud.plus.v1.csp.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 入离职登记表
 *
 * @author huych
 * @date 2025-02-25 14:48:11
 */
@Data
@TableName("employee_registration")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "入离职登记表")
public class EmployeeRegistration extends BaseEntity {

	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键ID")
	private String id;

	@ExcelProperty(value ="项目编码")
	private String deptNo;

	@ExcelProperty(value ="项目名称")
	private String deptName;

	@ExcelProperty(value ="项目id")
	private String deptId;

	@Schema(description = "员工姓名")
	private String employeeName;

	@Schema(description = "身份证号")
	private String empIdcard;

	@Schema(description = "员工手机号")
	private String empPhone;

	@Schema(description = "岗位")
	private String position;

	@Schema(description = "反馈类型 1入职 2离职")
	private String feedbackType;

	@Schema(description = "入/离职日期")
	private Date joinLeaveDate;

	@Schema(description = "处理状态,0已接收,1未处理,2已处理,3拒绝入职")
	private String processStatus;

	@Schema(description = "登记人")
	private String registorUsername;

	@Schema(description = "登记人所在部门名称")
	private String registorDeptname;

	@Schema(description = "登记人部门id")
	private String registorDeptid;

	@Schema(description = "登记人手机号")
	private String registorPhone;

	@Schema(description = "员工所在部门名称")
	private String empDeptname;

	@Schema(description = "员工部门id")
	private String empDeptid;

	@Schema(description = "客服手机号")
	private String customerPhone;

	@Schema(description = "客服姓名")
	private String customerUsername;

	@Schema(description = "客服登录名")
	private String customerUserLoginname;

	@Schema(description = "项目立项时间")
	@TableField(exist = false)
	private LocalDateTime projectCreateTime;

	@Schema(description = "数据来源")
	private String dataSource;

	@Schema(description = "最新的客服名称")
	private String customerUsernameNew;

	@Schema(description = "入职登记人数")
	@TableField(exist = false)
	private int inNum;

	@Schema(description = "离职登记人数")
	@TableField(exist = false)
	private int outNum;

	@Schema(description = "项目档案id")
	@TableField(exist = false)
	private String empProjectId;

	/**
	 * 附件Id
	 */
	@TableField(exist = false)
	private List<String> attaIdList;

	/**
	 * 印章附件
	 */
	@TableField(exist = false)
	private List<TCspAttaInfo> attaInfoList;



}
