package com.yifu.cloud.plus.v1.csp.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.csp.entity.TCspAttaInfo;
import com.yifu.cloud.plus.v1.csp.vo.TAttaInfoVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

/**
 * 附件信息表
 *
 * @author pwang
 * @date 2021-02-19 16:16:07
 */
@Mapper
public interface TAttaInfoMapper extends BaseMapper<TCspAttaInfo> {
    /**
     * 附件信息表简单分页查询
     *
     * @param tAttaInfo 附件信息表
     * @return
     */
    IPage<TCspAttaInfo> getTAttaInfoPage(Page<TCspAttaInfo> page, @Param("tAttaInfo") TCspAttaInfo tAttaInfo);

    /**
     * @param tAttaInfo
     * @Description: 获取list
     * @Author: hgw
     * @Date: 2021/5/28 16:02
     * @return: java.util.List<com.yifu.cloud.v1.crm.api.entity.TAttaInfo>
     **/
    List<TCspAttaInfo> getTAttaInfoList(@Param("tAttaInfo") TCspAttaInfo tAttaInfo);

    List<TCspAttaInfo> getTAttaInfoListByDoMainId(@Param("domainId") String domainId);

    List<TCspAttaInfo> getKeenAtta(@Param("dayStart")LocalDateTime dayStart, @Param("values")Collection<String> values);

    int updateDomainId(@Param("domainId")String domainId, @Param("ids")List<String> ids);

	List<TCspAttaInfo> getAttaByApplyId(@Param("applyId")String applyId);

	void deleteByDomainId(@Param("domainId") String domainId);
	// 详档变简档，删除身份证、其他附件、签名之外的附件
	void deleteByDomainIdExceptionCard(@Param("domainId") String domainId);

	void deleteByDomainIdAndType(@Param("domainId") String domainId, @Param("relationType") String relationType);

	// 删除学历与职业资格之外的附件
	void deleteByDomainIdAndOther(@Param("domainId") String domainId);

	// 简档，仅删除身份证附件和(21（预入职申明签名）；22（预入职确认签名）；23（预入职pdf文)
	void deleteByDomainIdCard(@Param("domainId") String domainId);

	List<TAttaInfoVo> getAttInfoByParam(@Param("departNo")String departNo, @Param("startDate")String startDate, @Param("endDate")String endDate);

	int getAttInfoCountByParam(@Param("departNo")String departNo, @Param("startDate")String startDate, @Param("endDate")String endDate);
}
