
package com.yifu.cloud.plus.v1.ekp.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 款项认领差额费导入
 *
 * @author huyc
 * @date 2024-07-04 14:54:40
 */
@Data
@ColumnWidth(30)
public class ClaimRebackInfotVO implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 款项认领明细单号
	 */
	@ExcelAttribute(name = "款项认领明细单号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="款项认领明细单号")
	private String claimNo;


	@ExcelAttribute(name = "项目编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="项目编码")
    private String deptNo;

	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="项目名称")
	private String deptName;

    /**
     * 认领金额
     */
	@ExcelAttribute(name = "认领金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="认领金额")
    private BigDecimal claimMoney;

	/**
	 * 核销金额
	 */
	@ExcelAttribute(name = "核销金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="核销金额")
	private BigDecimal cancelMoney;

	/**
	 * 剩余金额
	 */
	@NotNull(message = "剩余金额")
	@ExcelAttribute(name = "剩余金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="剩余金额")
	private BigDecimal surMoney;

	/**
	 * 调整金额
	 */
	@NotNull(message = "调整金额")
	@ExcelAttribute(name = "调整金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="调整金额")
	private BigDecimal adjustMoney;

	/**
	 * 剩余金额调整为
	 */
	@NotNull(message = "剩余金额调整为")
	@ExcelAttribute(name = "剩余金额调整为")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="剩余金额调整为")
	private BigDecimal afterAdjustMoney;

	/**
	 * 入账日期
	 */
	@NotNull(message = "入账日期")
	@ExcelAttribute(name = "入账日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="入账日期")
	private LocalDateTime claimTime;

	/**
	 * 异常说明
	 */
	@NotNull(message = "异常说明")
	@ExcelAttribute(name = "异常说明")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="异常说明")
	private String errorInfo;
}
