package com.yifu.cloud.plus.v1.ekp.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.ekp.entity.EkpManagerInfo;
import com.yifu.cloud.plus.v1.ekp.mapper.EkpManagerInfoMapper;
import com.yifu.cloud.plus.v1.ekp.service.EkpManagerInfoService;
import com.yifu.cloud.plus.v1.ekp.vo.EkpDeptInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpIncomePushInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpSocialPushInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.LocalDateTimeUtils;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpIncomeParamManage;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * @author huyc
 * @date 2024-03-14 10:14:37
 */
@Log4j2
@Service
public class EkpManagerInfoServiceImpl extends ServiceImpl<EkpManagerInfoMapper, EkpManagerInfo> implements EkpManagerInfoService {

	/**
	 * //@Description: 管理费明细推送至ekp
	 * //@Author: huyc
	 * //@Date: 2024-3-14
	 * //@return: void
	 **/
	public EkpIncomePushInfoVo pushManangerInfoToEkp(EkpIncomeParamManage incomeParam) {

		//根据项目编码获取ekp所有项目信息
		EkpDeptInfoVo deptInfo = baseMapper.getEkpDeptInfoByNo(incomeParam.getFd_3adfef5e5b9d34());
		if (null == deptInfo) {
			return null;
		}
		EkpManagerInfo managerInfoCount;
		try {
			//去重 防止重复推送
			managerInfoCount = baseMapper.selectOne(Wrappers.<EkpManagerInfo>query().lambda()
					.eq(EkpManagerInfo::getFd_3b13dc864a3052, incomeParam.getFd_3b13dae9bd70f8())
					.last(CommonConstants.LAST_ONE_SQL));
			if (Optional.ofNullable(managerInfoCount).isPresent()) {
				return null;
			}
			EkpManagerInfo managerInfo = new EkpManagerInfo();
			//对象信息赋值
			copyManagerProperties(incomeParam, managerInfo);

			//项目信息
			managerInfo.setFd_3b16e47cb6874c_text(deptInfo.getDeptName());
			managerInfo.setFd_3b16e47cb6874c(deptInfo.getFdId());
			//实际结算月份
			if ("结算月本月数据".equals(deptInfo.getSocialType())) {
				managerInfo.setFd_3ae0c23cb3fccc(incomeParam.getFd_3ae0c23cb3fccc());
			} else if ("结算月上月数据".equals(deptInfo.getSocialType())) {
				managerInfo.setFd_3ae0c23cb3fccc(DateUtil.dateToString(DateUtil.addMonthByDate(DateUtil.parseDate(incomeParam.getFd_3ae0c23cb3fccc(), "yyyy-MM"), -1), "yyyy-MM"));
			} else {
				managerInfo.setFd_3ae0c23cb3fccc("");
			}
			//是否全部结算
			managerInfo.setFd_3b13b15f5b63fa("全量未结算数据".equals(deptInfo.getSocialType()) ? "是" : "否");
			//创建时间
			managerInfo.setCreateTime(DateUtil.getCurrentDateTime());
			int i = baseMapper.insert(managerInfo);
			if (i>0) {
				EkpIncomePushInfoVo infoVo = new EkpIncomePushInfoVo();
				infoVo.setId(managerInfo.getFdId());
				return infoVo;
			}else {
				return null;
			}
		} catch (Exception e) {
			log.error("管理费明细推送失败:", e);
			return null;
		}
	}

	/**
	 * //@Description: 管理费明细推送至ekp
	 * //@Author: huyc
	 * //@Date: 2024-3-14
	 * //@return: void
	 **/
	public EkpSocialPushInfoVo jobPushManagerInfoToEkp(List<EkpIncomeParamManage> incomeParamList) {
		List<EkpManagerInfo> managerInfolist = new ArrayList<>();
		EkpManagerInfo managerInfoCount;
		EkpDeptInfoVo deptInfo;
		List<String> paymentIds = new ArrayList<>();
		try {
			for (EkpIncomeParamManage incomeParam : incomeParamList) {
				//根据项目编码获取ekp所有项目信息
				deptInfo = baseMapper.getEkpDeptInfoByNo(incomeParam.getFd_3adfef5e5b9d34());

				//去重 防止重复推送
				managerInfoCount = baseMapper.selectOne(Wrappers.<EkpManagerInfo>query().lambda()
						.eq(EkpManagerInfo::getFd_3b13dc864a3052, incomeParam.getFd_3b13dae9bd70f8())
						.last(CommonConstants.LAST_ONE_SQL));
				if (Optional.ofNullable(managerInfoCount).isPresent()) {
					return null;
				}
				EkpManagerInfo managerInfo = new EkpManagerInfo();
				//对象信息赋值
				copyManagerProperties(incomeParam, managerInfo);

				//项目信息
				managerInfo.setFd_3b16e47cb6874c_text(deptInfo.getDeptName());
				managerInfo.setFd_3b16e47cb6874c(deptInfo.getFdId());
				//实际结算月份
				if ("结算月本月数据".equals(deptInfo.getSocialType())) {
					managerInfo.setFd_3ae0c23cb3fccc(incomeParam.getFd_3ae0c23cb3fccc());
				} else if ("结算月上月数据".equals(deptInfo.getSocialType())) {
					managerInfo.setFd_3ae0c23cb3fccc(DateUtil.dateToString(DateUtil.addMonthByDate(DateUtil.parseDate(incomeParam.getFd_3ae0c23cb3fccc(), "yyyy-MM"), -1), "yyyy-MM"));
				} else {
					managerInfo.setFd_3ae0c23cb3fccc("");
				}
				//是否全部结算
				managerInfo.setFd_3b13b15f5b63fa("全量未结算数据".equals(deptInfo.getSocialType()) ? "是" : "否");
				//创建时间
				managerInfo.setCreateTime(DateUtil.getCurrentDateTime());
				managerInfolist.add(managerInfo);
				paymentIds.add(managerInfo.getFd_3b13dc864a3052());
			}
			if (!managerInfolist.isEmpty()) {
				boolean flag = this.saveBatch(managerInfolist);
				if (flag) {
					//推送成功保存社保明细合并的数据对应关系
					EkpSocialPushInfoVo pushInfoVo = new EkpSocialPushInfoVo();
					pushInfoVo.setPaymentIds(paymentIds);
					return pushInfoVo;
				}
			}
		} catch (Exception e) {
			log.error("管理费明细推送失败:", e);
			return null;
		}
		return null;
	}

	private void copyManagerProperties(EkpIncomeParamManage incomeParam, EkpManagerInfo managerInfo) {
		//项目编码
		managerInfo.setFd_3adfef5e5b9d34(incomeParam.getFd_3adfef5e5b9d34());
		//项目名称
		managerInfo.setFd_3adfef5eb6691c(incomeParam.getFd_3adfef5eb6691c());
		//单号
		managerInfo.setFd_3adfef7f5d2b52(incomeParam.getFd_3adfef7f5d2b52());
		//客户编码
		managerInfo.setFd_3adfef80202ab2(incomeParam.getFd_3adfef80202ab2());
		//客户名称
		managerInfo.setFd_3adfef7fc1c886(incomeParam.getFd_3adfef7fc1c886());
		//类型
		managerInfo.setFd_3adda3037e3bda(incomeParam.getFd_3adda3037e3bda());
		//产生来源
		managerInfo.setFd_3adda320daef5a(incomeParam.getFd_3adda320daef5a());
		//薪酬申请编号
		managerInfo.setFd_3b3bf110837a96(incomeParam.getFd_3b3bf13759b850());
		//姓名
		managerInfo.setFd_3adfef948da848(incomeParam.getFd_3adfef948da848());
		//身份证号
		managerInfo.setFd_3adfef94dcdbb4(incomeParam.getFd_3adfef94dcdbb4());
		//生成月份
		managerInfo.setFd_3ae0c23b2e9a92(incomeParam.getFd_3ae0c23b2e9a92());
		//HRO结算月
		managerInfo.setFd_3b13dd215b55b2(incomeParam.getFd_3ae0c23cb3fccc());
		//数据来源
		managerInfo.setFd_3b0b7231bb5896("HRO");
		//管理费ID
		managerInfo.setFd_3b13dc864a3052(incomeParam.getFd_3b13dae9bd70f8());
		//管理费金额
		managerInfo.setFd_3adfef963bae28(CommonConstants.EMPTY_STRING.equals(incomeParam.getFd_3adfef963bae28()) ? null : Double.parseDouble(incomeParam.getFd_3adfef963bae28()));
		//应收
		managerInfo.setFd_3adfefa3daae72(CommonConstants.EMPTY_STRING.equals(incomeParam.getFd_3adfefa3daae72()) ? null : Double.parseDouble(incomeParam.getFd_3adfefa3daae72()));
		//结算状态
		managerInfo.setFd_3adfefaaa3bbd0("未结算");
		//收款状态
		managerInfo.setFd_3adfefaaef583e("未收");
		//单号
		managerInfo.setFd_3adfef7f5d2b52("GLF" + LocalDateTimeUtils.formatTime(LocalDateTime.now(), DateUtil.DATE_PATTERN)
				+ "_" + managerInfo.getFd_3b13dc864a3052());
	}
}
