package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * @author huych
 * @description 险种信息返回类
 * @date 2024-10-30 10:26:33
 */
@Data
public class InsuranceTypeExportVo {

	private static final long serialVersionUID = 1L;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String name;

	/**
	 * 所属保险公司名称
	 */
	@Schema(description = "所属保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 收款银行名称
	 */
	@Schema(description = "收款银行名称")
	private String bankName;

	/**
	 * 收款银行账号
	 */
	@Schema(description = "收款银行账号")
	private String bankNo;

	/**
	 * 收款单位名称
	 */
	@Schema(description = "收款单位名称")
	private String receiptUnitName;

	/**
	 * 购买年龄限制 0 限制  1 不限制
	 */
	@Schema(description = "购买年龄限制")
	private String ageLimit;

	/**
	 * 是否地市自购0是 1 否
	 */
	@Schema(description = "是否地市自购")
	private String isAdress;

	/**
	 * 启用状态 0是 1 否
	 */
	@Schema(description = "启用状态")
	private String enable;

}
