package com.yifu.cloud.plus.v1.job.compont;


import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprEkpPermissionProperties;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.HttpDaprUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @Author hgw
 * @Description EKP权限定时任务
 * @Date 2023-9-5 09:40:09
 **/
@Component(value = "ekpPermissionTask")
@Slf4j
@EnableConfigurationProperties(DaprEkpPermissionProperties.class)
public class EkpPermissionTask {

	@Autowired
	private DaprEkpPermissionProperties daprEkpPermissionProperties;

	/**
	 * @return
	 * @Author hgw
	 * @Description 刷新EKP权限里的账号信息
	 * @Date 2023-9-5 09:45:22
	 * @Param
	 **/
	public void doRefreshEkpUser() throws Exception {
		log.info("-------------刷新EKP权限里的账号信息-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprEkpPermissionProperties.getAppUrl(), daprEkpPermissionProperties.getAppId(),
				"/sysuserinfo/inner/doRefreshEkpUser", "", Object.class,
				SecurityConstants.FROM_IN);
		log.info("-------------刷新EKP权限里的账号信息-定时任务结束------------");
	}

	/**
	 * @return
	 * @Author hgw
	 * @Description 每天1点，定时同步企业微信审批出差数据
	 * @Date 2024-4-15 18:24:06
	 * @Param
	 **/
	public void doSaveQiWeiChuChai() throws Exception {
		log.info("-------------获取企业微信出差数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprEkpPermissionProperties.getAppUrl(), daprEkpPermissionProperties.getAppId(),
				"/qiWei/inner/everyDaySaveQiWeiChuChai", "", Object.class,
				SecurityConstants.FROM_IN);
		log.info("-------------获取企业微信出差数据-定时任务结束------------");
	}

	/**
	 * @return
	 * @Author hgw
	 * @Description 每天2点，定时同步HCM审批出差数据
	 * @Date 2024-4-29 15:59:31
	 * @Param
	 **/
	public void doSaveHcmChuChai() throws Exception {
		log.info("-------------获取HCM出差数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprEkpPermissionProperties.getAppUrl(), daprEkpPermissionProperties.getAppId(),
				"/qiWei/inner/everyDaySaveHcmChuChai", "", Object.class,
				SecurityConstants.FROM_IN);
		log.info("-------------获取HCM出差数据-定时任务结束------------");
	}

	/**
	 * @Author hgw
	 * @Description 每天1点30，定时同步企微招聘数据
	 * @Date 2024-8-28 11:39:32
	 * @Param
	 **/
	public void everyDaySaveQiWeiZhaoPin() throws Exception {
		log.info("-------------获取企微招聘数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprEkpPermissionProperties.getAppUrl(), daprEkpPermissionProperties.getAppId(),
				"/qiWei/inner/everyDaySaveQiWeiZhaoPin", "", Object.class,
				SecurityConstants.FROM_IN);
		log.info("-------------获取企微招聘数据-定时任务结束------------");
	}

	/**
	 * 每天2点30，定时同步昨天HCM审批加班数据
	 * @author chenyuxi
	 * @since  1.9.6
	 * @date   2025-02-06
	 **/
	public void doSaveHcmWorkOvertime() throws Exception {
		log.info("-------------获取HCM加班数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprEkpPermissionProperties.getAppUrl(), daprEkpPermissionProperties.getAppId(),
				"/qiWei/inner/everyDaySaveHcmWorkOvertime", "", Object.class,
				SecurityConstants.FROM_IN);
		log.info("-------------获取HCM加班数据-定时任务结束------------");
	}
}
