package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 前12月平均工资（MVP-TDC接口）
 * 保留上月与本月，删除上上月数据，用以比对差异部分，推送到TDC
 *
 * @author hgw
 * @date 2023-6-19 15:54:50
 */
@Getter
@Setter
@TableName("t_average_salary")
@Tag(name = "前12月平均工资")
public class TAverageSalary implements Serializable {
	private static final long serialVersionUID = 1L;
	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "id")
	private String id;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", maxLength = 25)
	@Length(max = 25, message = "身份证号不能超过25个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 应发薪酬（劳务费、稿酬）
	 */
	@ExcelAttribute(name = "应发薪酬")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("应发薪酬")
	private BigDecimal averageSalary;

	/**
	 * 结算月
	 */
	@ExcelAttribute(name = "生成月", isNotEmpty = true, errorInfo = "生成月不能为空", maxLength = 6)
	@NotBlank(message = "生成月不能为空")
	@Length(max = 6, message = "生成月不能超过20个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生成月")
	private String createMonth;
}
