package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ServiceNameConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.MenuUtil;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccountItem;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandard;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryAccountItemService;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryAccountService;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryStandardService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.SalaryAccountAndItemVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.SettlementFormVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryStandardSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;


/**
 * B端工资接口
 *
 * @author hgw
 * @date 2020-8-19 09:39:06
 */
@RestController
@AllArgsConstructor
@RequestMapping("/customerBusiness/businessSalary")
@Tag(name = "B端工资接口")
public class BusinessSalaryController {

	// 工资表服务
	private final TSalaryStandardService tSalaryStandardService;

	// 工资报表服务
	private final TSalaryAccountService tSalaryAccountService;

	// 工资明细
	private final TSalaryAccountItemService tSalaryAccountItemService;

	private final MenuUtil menuUtil;

	// 工资明细属性
	private static final String JAVA_FIED_NAME = "JAVA_FIED_NAME";
	// 应发
	private static final String RELAY_SALARY = "relaySalary";
	// 实发
	private static final String ACTUAL_SALARY_SUM = "actualSalarySum";
	// 个税
	private static final String SALARY_TAX = "salaryTax";
	// 单位社保
	private static final String UNIT_SOCIAL = "unitSocial";
	// 个人社保
	private static final String PERSONAL_SOCIAL = "personalSocial";
	// 单位社保
	private static final String UNIT_FUND = "unitFund";
	// 个人公积金
	private static final String PERSONAL_FUND = "personalFund";

	/**
	 * @param page             分页
	 * @param settlementFormVo 结算单vo
	 * @Description: B端薪酬第一个统计列表
	 * @Author: hgw
	 * @Date: 2020-8-21 16:17:51
	 * @return: com.yifu.cloud.v1.common.core.util.R<com.baomidou.mybatisplus.core.metadata.IPage < com.yifu.cloud.v1.hrms.api.vo.SettlementFormVo>>
	 **/
	@Operation(description = "1薪酬首列表-分页查询")
	@GetMapping("/getSettlementFormVoPage")
	public R<IPage<SettlementFormVo>> getSettlementFormVoPage(Page<SettlementFormVo> page, SettlementFormVo settlementFormVo) {
		if (Boolean.TRUE.equals(Common.isEmpty(settlementFormVo.getYears()))) {
			// 当前年份
			String curYear = DateUtil.getYear(new Date());
			settlementFormVo.setYears(curYear);
		}
		YifuUser user = SecurityUtils.getUser();
		if (user == null) {
			return R.failed("请登录!");
		}
		List<String> settleDepartIdList = null;
		if (!SecurityUtils.isHaveAllOrg(ServiceNameConstants.CLIENT_ID_HR_B, user)) {
			settleDepartIdList = user.getSettleIdList();
			if (settleDepartIdList == null || settleDepartIdList.isEmpty()) {
				return R.failed("无结算主体权限，请联系管理员分配！");
			}
		}
		return new R<>(tSalaryAccountService.getSettlementFormVoPage(page, settlementFormVo, settleDepartIdList));
	}

	/**
	 * @param page            分页信息
	 * @param tSalaryStandard 工资表
	 * @Description: 工资列表-分页查询
	 * @Author: hgw
	 * @Date: 2020-8-21 16:17:45
	 * @return: com.yifu.cloud.v1.common.core.util.R<com.baomidou.mybatisplus.core.metadata.IPage < com.yifu.cloud.v1.hrms.api.entity.TSalaryStandard>>
	 **/
	@Operation(description = "2工资列表-分页查询(salaryMonth必传)")
	@GetMapping("/getSalaryStandardPage")
	public R<IPage<TSalaryStandard>> getSalaryStandardPage(Page<TSalaryStandard> page, TSalaryStandardSearchVo tSalaryStandard
			, String createTimeStart, String createTimeEnd, String revenueTimeStart, String revenueTimeEnd) {
		if (Boolean.TRUE.equals(Common.isEmpty(tSalaryStandard.getSalaryMonth()))) {
			tSalaryStandard.setSalaryMonth("-1");
		}
		tSalaryStandard.setDeleteFlag(CommonConstants.ZERO_INT);
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, tSalaryStandard);
		return new R<>(tSalaryStandardService.getTSalaryStandardPageApply(page, tSalaryStandard));
	}

	/**
	 * 工资详情-报账列表-分页查询
	 *
	 * @param page                   分页对象
	 * @param salaryAccountAndItemVo 工资详情-报账列表-分页查询
	 * @return
	 * @Author: hgw
	 * @Date: 2020-8-21 16:16:24
	 */
	@Operation(description = "3工资详情-报账列表-分页查询(salaryFormId必传)")
	@GetMapping("/getSalaryAccountAndItemVoPage")
	public R<IPage<SalaryAccountAndItemVo>> getSalaryAccountPage(Page<SalaryAccountAndItemVo> page
			, SalaryAccountAndItemVo salaryAccountAndItemVo) {
		if (Boolean.TRUE.equals(Common.isEmpty(salaryAccountAndItemVo.getSalaryFormId()))) {
			salaryAccountAndItemVo.setSalaryFormId(CommonConstants.ZERO_STRING);
		}
		// 分页报账以及详情数据
		IPage<SalaryAccountAndItemVo> accountPage = getSalaryAccountAndItemVoIPage(page, salaryAccountAndItemVo);
		return new R<>(accountPage);
	}

	/**
	 * @param salaryAccountId 报账id
	 * @Description: 获取报账明细
	 * @Author: hgw
	 * @Date: 2020/8/21 17:39
	 * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.TSalaryAccountItem>
	 **/
	private List<TSalaryAccountItem> gettSalaryAccountItemList(String salaryAccountId) {
		TSalaryAccountItem item = new TSalaryAccountItem();
		item.setSalaryAccountId(salaryAccountId);
		QueryWrapper<TSalaryAccountItem> queryWrapperAi = new QueryWrapper<>();
		queryWrapperAi.setEntity(item);
		queryWrapperAi.ne(JAVA_FIED_NAME, RELAY_SALARY);
		queryWrapperAi.ne(JAVA_FIED_NAME, ACTUAL_SALARY_SUM);
		queryWrapperAi.ne(JAVA_FIED_NAME, SALARY_TAX);
		queryWrapperAi.ne(JAVA_FIED_NAME, UNIT_SOCIAL);
		queryWrapperAi.ne(JAVA_FIED_NAME, PERSONAL_SOCIAL);
		queryWrapperAi.ne(JAVA_FIED_NAME, UNIT_FUND);
		queryWrapperAi.ne(JAVA_FIED_NAME, PERSONAL_FUND);
		return tSalaryAccountItemService.list(queryWrapperAi);
	}

	/**
	 * 工资详情-报账列表-分页查询
	 *
	 * @param page                   分页对象
	 * @param salaryAccountAndItemVo 工资详情-报账列表-分页查询
	 * @return
	 * @Author: hgw
	 * @Date: 2020-8-21 16:16:24
	 */
	@Operation(description = "3.2人员-报账列表(empIdcard必传)")
	@GetMapping("/getAccountByIdCardPage")
	public R<IPage<SalaryAccountAndItemVo>> getAccountByIdCardPage(Page<SalaryAccountAndItemVo> page
			, SalaryAccountAndItemVo salaryAccountAndItemVo) {
		if (Boolean.TRUE.equals(Common.isEmpty(salaryAccountAndItemVo.getEmpIdcard()))) {
			salaryAccountAndItemVo.setEmpIdcard("-1");
		}
		if (Boolean.TRUE.equals(Common.isEmpty(salaryAccountAndItemVo.getYears()))) {
			// 当前年份
			String curYear = DateUtil.getYear(new Date());
			salaryAccountAndItemVo.setYears(curYear);
		}
		// 发放状态 0: 未发放 1: 发放成功 2:发放失败
		salaryAccountAndItemVo.setDistributionFlag(CommonConstants.ONE_STRING);
		// 分页报账以及详情数据
		IPage<SalaryAccountAndItemVo> accountPage = getSalaryAccountAndItemVoIPage(page, salaryAccountAndItemVo);
		return new R<>(accountPage);
	}

	/**
	 * @param page                   分页
	 * @param salaryAccountAndItemVo 报账信息
	 * @Description: 获取报账分页数据
	 * @Author: hgw
	 * @Date: 2020/8/21 17:42
	 * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.yifu.cloud.v1.hrms.api.vo.SalaryAccountAndItemVo>
	 **/
	private IPage<SalaryAccountAndItemVo> getSalaryAccountAndItemVoIPage(Page<SalaryAccountAndItemVo> page
			, SalaryAccountAndItemVo salaryAccountAndItemVo) {
		IPage<SalaryAccountAndItemVo> accountPage = tSalaryAccountService
				.getSalaryAccountAndItemVoPage(page, salaryAccountAndItemVo);
		// 报账列表
		List<SalaryAccountAndItemVo> accountList = accountPage.getRecords();
		if (accountList != null && !accountList.isEmpty()) {
			// 获取报账明细
			for (SalaryAccountAndItemVo a : accountList) {
				a.setSaiList(gettSalaryAccountItemList(a.getId()));
			}
		}
		return accountPage;
	}

	/**
	 * @param salaryFormId 工资id
	 * @Description: 工资详情-上面的统计
	 * @Author: hgw
	 * @Date: 2020/8/21 17:54
	 * @return: com.yifu.cloud.v1.common.core.util.R<com.yifu.cloud.v1.hrms.api.vo.SettlementFormVo>
	 **/
	@Operation(description = "3.3工资详情-上面的统计(salaryFormId必传)")
	@GetMapping("/getSettlementStasticsBySalaryFormId")
	public R<SettlementFormVo> getSettlementStasticsBySalaryFormId(String salaryFormId) {
		if (Boolean.TRUE.equals(Common.isEmpty(salaryFormId))) {
			salaryFormId = CommonConstants.ZERO_STRING;
		}
		// 分页报账以及详情数据
		SettlementFormVo settlementFormVo = tSalaryAccountService.getSettlementFormVoBySalaryFormId(salaryFormId);
		return new R<>(settlementFormVo);
	}

}
