package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.salary.constants.SalaryConstants;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryConfigStandard;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryConfigStandardService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.List;


/**
 * @Author fxj
 * @Description 薪资识别配置（标准模板）
 * @Date 13:32 2022/8/6
 * @Param
 * @return
**/
@RestController
@AllArgsConstructor
@RequestMapping("/tsalaryconfigstandard")
@Tag(name = "薪资识别配置（标准模板）")
public class TSalaryConfigStandardController {

	private final TSalaryConfigStandardService tSalaryConfigStandardService;

	// 获取登录人信息为空
	private static final String NO_USER = "获取登录人信息为空";

	/**
	 * 简单分页查询
	 *
	 * @param page                  分页对象
	 * @param tSalaryConfigStandard 薪资识别配置（标准模板）
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TSalaryConfigStandard>> getTSalaryConfigStandardPage(Page<TSalaryConfigStandard> page, TSalaryConfigStandard tSalaryConfigStandard) {
		return new R<>(tSalaryConfigStandardService.getTSalaryConfigStandardPage(page, tSalaryConfigStandard));
	}

	/**
	 * @param tSalaryConfigStandard
	 * @Description: 获取列表
	 * @Author: hgw
	 * @Date: 2021/1/7 11:39
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.util.List < com.yifu.cloud.v1.hrms.api.entity.TSalaryConfigStandard>>
	 **/
	@Operation(description = "获取配置列表")
	@GetMapping("/getTSalaryConfigStandardList")
	public R<List<TSalaryConfigStandard>> getTSalaryConfigStandardList(TSalaryConfigStandard tSalaryConfigStandard) {
		return new R<>(tSalaryConfigStandardService.getTSalaryConfigStandardList(tSalaryConfigStandard));
	}


	/**
	 * 通过id查询单条记录
	 *
	 * @param id
	 * @return R
	 */
	@Operation(description = "id查询")
	@GetMapping("/{id}")
	public R<TSalaryConfigStandard> getById(@PathVariable("id") String id) {
		return new R<>(tSalaryConfigStandardService.getById(id));
	}

	/**
	 * 新增记录
	 *
	 * @param tSalaryConfigStandard
	 * @return R
	 */
	@Operation(description = "查询薪资识别配置是否已存在")
	@SysLog("查询薪资识别配置是否已存在")
	@PostMapping("/findExistence")
	public R<String> findExistence(@RequestBody TSalaryConfigStandard tSalaryConfigStandard) {
		if (tSalaryConfigStandard != null) {
			if (Common.isNotNull(tSalaryConfigStandard.getCnName())
					&& Common.isNotNull(tSalaryConfigStandard.getDbFiedName())) {
				IPage<TSalaryConfigStandard> scsPage = tSalaryConfigStandardService.getTSalaryConfigStandardPage(new Page(), tSalaryConfigStandard);
				if (scsPage != null && scsPage.getTotal() > CommonConstants.ZERO_INT) {
					return R.failed("已存在配置");
				} else {
					return R.ok("可以保存");
				}
			} else {
				return R.failed("查找的信息不全");
			}
		}
		return R.failed("查找的信息不全");
	}

	/**
	 * 新增记录
	 *
	 * @param tSalaryConfigStandard
	 * @return R
	 */
	@Operation(description = "新增 wxhr:tsalaryconfigstandard_add")
	@SysLog("新增薪资识别配置（标准模板）")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('wxhr:tsalaryconfigstandard_add')")
	public R<Boolean> save(@RequestBody TSalaryConfigStandard tSalaryConfigStandard) {
		YifuUser user = SecurityUtils.getUser();
		if (null == user || null == user.getId()) {
			return R.failed(NO_USER);
		}
		long res = tSalaryConfigStandardService.count(Wrappers.<TSalaryConfigStandard>query().lambda()
				.eq(TSalaryConfigStandard::getDbFiedName,tSalaryConfigStandard.getDbFiedName()));
		if (res > 0){
			return R.failed("已存在系统标准数据项");
		}
		// 填充个人代扣等java字段
		this.setJavaFiedName(tSalaryConfigStandard);
		tSalaryConfigStandard.setCreateBy(String.valueOf(user.getId()));
		tSalaryConfigStandard.setCreateTime(LocalDateTime.now());
		tSalaryConfigStandard.setIsMustNeed(CommonConstants.ZERO_STRING);
		tSalaryConfigStandard.setModelType(CommonConstants.ONE_STRING);
		tSalaryConfigStandard.setIsTax(CommonConstants.ZERO_INT);
		return new R<>(tSalaryConfigStandardService.save(tSalaryConfigStandard));
	}

	/**
	 * 修改记录
	 *
	 * @param tSalaryConfigStandard
	 * @return R
	 */
	@Operation(description = "修改 wxhr:tsalaryconfigstandard_edit")
	@SysLog("修改薪资识别配置（标准模板）")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('wxhr:tsalaryconfigstandard_edit')")
	public R<Boolean> update(@RequestBody TSalaryConfigStandard tSalaryConfigStandard) {
		YifuUser user = SecurityUtils.getUser();
		if (null == user || null == user.getId()) {
			return R.failed(NO_USER);
		}
		long res = tSalaryConfigStandardService.count(Wrappers.<TSalaryConfigStandard>query().lambda()
				.eq(TSalaryConfigStandard::getDbFiedName,tSalaryConfigStandard.getDbFiedName())
				.ne(TSalaryConfigStandard::getId,tSalaryConfigStandard.getId()));
		if (res > 0){
			return R.failed("已存在系统标准数据项");
		}
		// 填充个人代扣等java字段
		this.setJavaFiedName(tSalaryConfigStandard);
		if (String.valueOf(user.getId()).equals(tSalaryConfigStandard.getCreateBy())) {
			return new R<>(tSalaryConfigStandardService.updateById(tSalaryConfigStandard));
		} else {
			return R.failed("不可修改非自己创建的！");
		}
	}

	/**
	 * @param tSalaryConfigStandard
	 * @Description: 填充个人代扣等java字段
	 * @Author: hgw
	 * @Date: 2022/4/26 16:50
	 * @return: void
	 **/
	private void setJavaFiedName(@RequestBody TSalaryConfigStandard tSalaryConfigStandard) {
		if (Common.isNotNull(tSalaryConfigStandard.getCnName())) {
			if (tSalaryConfigStandard.getCnName().contains("个人代扣-")) {
				tSalaryConfigStandard.setJavaFiedName(SalaryConstants.PDEDUCTION_JAVA);
			} else if (tSalaryConfigStandard.getCnName().contains("单位代扣-")) {
				tSalaryConfigStandard.setJavaFiedName(SalaryConstants.UDEDUCTION_JAVA);
			}
		}
	}

	/**
	 * 通过id删除一条记录
	 *
	 * @param id
	 * @return R
	 */
	@Operation(description = "删除 wxhr:tsalaryconfigstandard_del")
	@SysLog("删除薪资识别配置（标准模板）")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('wxhr:tsalaryconfigstandard_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		YifuUser user = SecurityUtils.getUser();
		if (null == user || null == user.getId()) {
			return R.failed(NO_USER);
		}
		TSalaryConfigStandard sc = tSalaryConfigStandardService.getById(id);
		if (String.valueOf(user.getId()).equals(sc.getCreateBy())) {
			return new R<>(tSalaryConfigStandardService.removeById(id));
		} else {
			return R.failed("不可删除非自己创建的！");
		}
	}

}
