/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardIssueRes;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryStandardIssueResSearchVo;

import java.util.List;

/**
 * 薪资表与代发户表关联表
 *
 * @author hgw
 * @date 2023-01-10 11:34:27
 */
public interface TSalaryStandardIssueResService extends IService<TSalaryStandardIssueRes> {
	/**
	 * @Description: 薪资表与代发户表关联表简单不分页查询
	 * @Author: hgw
	 * @Date: 2023/1/10 14:34
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardIssueRes>
	 **/
	List<TSalaryStandardIssueRes> noPageDiy(TSalaryStandardIssueResSearchVo searchVo);
}
