/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount2022;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TSalaryAccount2022Mapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryAccount2022Service;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

/**
 * 工资报账主表2022
 *
 * @author hgw
 * @date 2022-08-05 11:40:15
 */
@Log4j2
@Service
public class TSalaryAccount2022ServiceImpl extends ServiceImpl<TSalaryAccount2022Mapper, TSalaryAccount2022> implements TSalaryAccount2022Service {

	/**
	 * @param
	 * @Description: 生成工资报账主表2020
	 * @Author: hgw
	 * @Date: 2020/12/31 17:55
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
	 **/
	@Override
	public R<String> doRefreshSalaryAccountByMonth(String tableName, String lastMonth) {
		if (Common.isEmpty(tableName)) {
			tableName = "t_salary_account_" + lastMonth.substring(0, 4);
		}
		baseMapper.createAccountYear(tableName);
		int firstDelete = baseMapper.deleteSalaryAccountYearByMonth(tableName, lastMonth);
		if (firstDelete != -1) {
			int firstCreate = baseMapper.insertIntoSalaryAccountYear(tableName, lastMonth);
			if (firstCreate != -1) {
				return R.ok("已生成【年度报账】！");
			} else {
				return R.failed("生成【年度报账】失败！");
			}
		} else {
			return R.failed("删除【年度报账】失败！");
		}
	}
}
