package com.yifu.cloud.plus.v1.yifu.admin.api.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 客户服务平台——部门树
 *
 * @author chenyuxi
 * @since 1.9.7
 */
@Data
public class DeptTreeSelectVO implements Serializable {
	private static final long serialVersionUID = 1L;
	/**
	 * 部门ID
	 */
	private Long deptId;
	/**
	 * 父部门ID
	 */
	private Long parentId;

	/**
	 * 祖级列表
	 */
	private String ancestors;

	/**
	 * 部门名称
	 */
	private String name;

	/**
	 * 父部门名称
	 */
	private String parentName;

	/**
	 * 部门总人数
	 */
	private  String peopleNum;

	private Integer sortOrder;


	private List<DeptTreeSelectVO> children;

	public DeptTreeSelectVO(SysDeptVo dept) {
		this.deptId = dept.getDeptId();
		this.parentId = dept.getParentId();
		this.ancestors = dept.getAncestors();
		this.name = dept.getName();
		this.sortOrder = dept.getSortOrder();
		this.parentName = dept.getParentName();
		this.peopleNum =dept.getPeopleNum();
		if(dept.getChildren() != null){
			this.children = dept.getChildren().stream().map(DeptTreeSelectVO::new).collect(Collectors.toList());
		}
	}
}
