/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 项目基础薪酬配置-薪资配置2
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class TConfigSalaryVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 32)
	@Schema(description = "主键")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 配置名称
	 */
	@NotBlank(message = "配置名称 不能为空")
	@Length(max = 50, message = "配置名称 不能超过50 个字符")
	@ExcelAttribute(name = "配置名称", isNotEmpty = true, errorInfo = "配置名称 不能为空", maxLength = 50)
	@Schema(description = "配置名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("配置名称")
	private String name;
	/**
	 * 结算主体ID
	 */
	@NotBlank(message = "结算主体ID 不能为空")
	@Length(max = 32, message = "结算主体ID 不能超过32 个字符")
	@ExcelAttribute(name = "结算主体ID", isNotEmpty = true, errorInfo = "结算主体ID 不能为空", maxLength = 32)
	@Schema(description = "结算主体ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算主体ID")
	private String departId;
	/**
	 * 结算主体编码
	 */
	@NotBlank(message = "结算主体编码 不能为空")
	@Length(max = 32, message = "结算主体编码 不能超过32 个字符")
	@ExcelAttribute(name = "结算主体编码", isNotEmpty = true, errorInfo = "结算主体编码 不能为空", maxLength = 32)
	@Schema(description = "结算主体编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算主体编码")
	private String departNo;
	/**
	 * 结算主体名称
	 */
	@NotBlank(message = "结算主体名称 不能为空")
	@Length(max = 50, message = "结算主体名称 不能超过50 个字符")
	@ExcelAttribute(name = "结算主体名称", isNotEmpty = true, errorInfo = "结算主体名称 不能为空", maxLength = 50)
	@Schema(description = "结算主体名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算主体名称")
	private String departName;
	/**
	 * 薪酬月份
	 */
	@NotBlank(message = "薪酬月份 不能为空")
	@ExcelAttribute(name = "薪酬月份", isNotEmpty = true, errorInfo = "薪酬月份 不能为空")
	@Schema(description = "薪酬月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("薪酬月份")
	private Integer salaryMonth;
	/**
	 * 社保月份
	 */
	@NotBlank(message = "社保月份 不能为空")
	@ExcelAttribute(name = "社保月份", isNotEmpty = true, errorInfo = "社保月份 不能为空")
	@Schema(description = "社保月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保月份")
	private Integer socialMonth;
	/**
	 * 公积金月份
	 */
	@NotBlank(message = "公积金月份 不能为空")
	@ExcelAttribute(name = "公积金月份", isNotEmpty = true, errorInfo = "公积金月份 不能为空")
	@Schema(description = "公积金月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金月份")
	private Integer fundMonth;
	/**
	 * 社保优先级0：生成月；1：缴纳月
	 */
	@NotBlank(message = "社保优先级0：生成月；1：缴纳月 不能为空")
	@ExcelAttribute(name = "社保优先级0：生成月；1：缴纳月", isNotEmpty = true, errorInfo = "社保优先级0：生成月；1：缴纳月 不能为空")
	@Schema(description = "社保优先级0：生成月；1：缴纳月")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保优先级0：生成月；1：缴纳月")
	private Integer socialPriority;
	/**
	 * 公积金优先级0：生成月；1：缴纳月
	 */
	@NotBlank(message = "公积金优先级0：生成月；1：缴纳月 不能为空")
	@ExcelAttribute(name = "公积金优先级0：生成月；1：缴纳月", isNotEmpty = true, errorInfo = "公积金优先级0：生成月；1：缴纳月 不能为空")
	@Schema(description = "公积金优先级0：生成月；1：缴纳月")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金优先级0：生成月；1：缴纳月")
	private Integer fundPriority;
	/**
	 * 发放方式（0现金/1银行）
	 */
	@NotBlank(message = "发放方式（0现金/1银行） 不能为空")
	@ExcelAttribute(name = "发放方式（0现金/1银行）", isNotEmpty = true, errorInfo = "发放方式（0现金/1银行） 不能为空")
	@Schema(description = "发放方式（0现金/1银行）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("发放方式（0现金/1银行）")
	private Integer grantType;

}
