package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author fxj
 * @Date 2022/8/8
 * @Description
 * @Version 1.0
 */
@Data
public class TSalaryStandardUnprojectVo implements Serializable {
	/**
	 * 工资表id
	 */
	private String salaryId;

	/**
	 * 项目名称
	 */
	private String deptName;

	/**
	 * 项目编码
	 */
	private String deptNo;

	/**
	 * 申请编号
	 */
	private String applyNo;

	/**
	 * 工资月份（YYYYMM）
	 */
	private String salaryMonth;

	/**
	 * 结算月
	 */
	private String settlementMonth;

	/**
	 * 应发薪酬（劳务费、稿酬）
	 */
	private BigDecimal relaySalary;

	/**
	 * 实发（个人实收）
	 */
	private BigDecimal actualSalary;

	/**
	 * 员工姓名
	 */
	private String empName;

	/**
	 * 员工身份证号
	 */
	private String empIdcard;

	/**
	 * 创建时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间")
	private LocalDateTime createTime;

	/**
	 * 创建者-姓名
	 */
	@Schema(description = "创建人-姓名")
	private String createName;
}
