/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialDeadlineInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TSocialDeadlineInfoSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * 社保医疗截止日配置
 *
 * @author fxj
 * @date 2024-05-08 11:52:09
 */
public interface TSocialDeadlineInfoService extends IService<TSocialDeadlineInfo> {
	/**
	 * 社保医疗截止日配置简单分页查询
	 *
	 * @param tSocialDeadlineInfo 社保医疗截止日配置
	 * @return
	 */
	IPage<TSocialDeadlineInfo> getTSocialDeadlineInfoPage(Page<TSocialDeadlineInfo> page, TSocialDeadlineInfoSearchVo tSocialDeadlineInfo);

	R<List<ErrorMessage>> importDiy(InputStream inputStream);

	void listExport(HttpServletResponse response, TSocialDeadlineInfoSearchVo searchVo);

	List<TSocialDeadlineInfo> noPageDiy(TSocialDeadlineInfoSearchVo searchVo);

	void createDeadLineSetInfo();

	R<Boolean>  updateByIdAsso(TSocialDeadlineInfo tSocialDeadlineInfo);

	R<Boolean>  saveAsso(TSocialDeadlineInfo tSocialDeadlineInfo);

	/**
	 * @Description: 获取 当月启用 的配置
	 * @Author: hgw
	 * @Date: 2024/9/2 15:26
	 * @return: java.util.Map<java.lang.String, com.yifu.cloud.plus.v1.yifu.social.entity.TSocialDeadlineInfo>
	 **/
	Map<String, TSocialDeadlineInfo> getSocialSet();

	Map<String, TSocialDeadlineInfo> getSocialSetByAreaId();

}
