/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * 项目配置表主表
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
@Data
@TableName("t_auto_main_rel")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "项目配置表主表")
public class TAutoMainRel extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", isNotEmpty = true, errorInfo = "项目编码不能为空", maxLength = 50)
	@NotBlank(message = "项目编码不能为空")
	@Length(max = 50, message = "项目编码不能超过50个字符")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String deptNo;
	/**
	 * 项目ID
	 */
	@ExcelAttribute(name = "项目ID", isNotEmpty = true, errorInfo = "项目ID不能为空", maxLength = 32)
	@NotBlank(message = "项目ID不能为空")
	@Length(max = 32, message = "项目ID不能超过32个字符")
	@ExcelProperty("项目ID")
	@Schema(description = "项目ID")
	private String deptId;
	/**
	 * 规则最新更新时间
	 */
	@ExcelAttribute(name = "规则最新更新时间", isDate = true)
	@ExcelProperty("规则最新更新时间")
	@Schema(description = "规则最新更新时间")
	private Date ruleUpdateTime;
	/**
	 * 规则最新更新人
	 */
	@ExcelAttribute(name = "最新更新人", maxLength = 50)
	@Length(max = 50, message = "最新更新人不能超过50个字符")
	@ExcelProperty("最新更新人")
	@Schema(description = "最新更新人")
	private String ruleUpdatePerson;

	/**
	 * 服务状态：0正常 1停止服务 2冻结   （是否使用：0是 非0否）
	 */
	@Schema(description = "服务状态：0正常 1停止服务 2冻结")
	@TableField(exist = false)
	private String stopFlag;
	/**
	 * 岗位是否统一
	 */
	@ExcelAttribute(name = "岗位是否统一", maxLength = 1)
	@Schema(description = "岗位是否统一 0是 1 否")
	private String postFlag;

	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	@TableField(exist = false)
	private String departName;

	/**
	 * 前端客服
	 */
	@Schema(description = "前端客服")
	@TableField(exist = false)
	private String csUserName;

}
