package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * 入职登记发送短信记录表
 *
 * @author huych
 * @date 2025-03-18 16:54:51
 */
@Data
@TableName("t_regist_warning_employee")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "入职登记发送短信记录表")
public class TRegistWarningEmployee extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private Integer id;
	/**
	 * 入职待建档明细id
	 */
	@ExcelAttribute(name = "入职待建档明细id", isNotEmpty = true, errorInfo = "入职待建档明细id不能为空", maxLength = 32)
	@NotBlank(message = "入职待建档明细id不能为空")
	@Length(max = 32, message = "入职待建档明细id不能超过32个字符")
	@ExcelProperty("入职待建档明细id")
	@Schema(description = "入职待建档明细id")
	private String warningId;
	/**
	 * 姓名
	 */
	@ExcelAttribute(name = "姓名", maxLength = 32)
	@Length(max = 32, message = "姓名不能超过32个字符")
	@ExcelProperty("姓名")
	@Schema(description = "姓名")
	private String empName;
	/**
	 * 身份证
	 */
	@ExcelAttribute(name = "身份证", maxLength = 50)
	@Length(max = 50, message = "身份证不能超过50个字符")
	@ExcelProperty("身份证")
	@Schema(description = "身份证")
	private String empIdcard;
	/**
	 * 联系方式
	 */
	@ExcelAttribute(name = "联系方式", maxLength = 50)
	@Length(max = 50, message = "联系方式不能超过50个字符")
	@ExcelProperty("联系方式")
	@Schema(description = "联系方式")
	private String empPhone;
	/**
	 * 发送时间
	 */
	@ExcelAttribute(name = "发送时间", isDate = true)
	@ExcelProperty("发送时间")
	@Schema(description = "发送时间")
	private Date sendDate;
	/**
	 * 回执id
	 */
	@ExcelAttribute(name = "回执id", maxLength = 50)
	@Length(max = 50, message = "回执id不能超过50个字符")
	@ExcelProperty("回执id")
	@Schema(description = "回执id")
	private String bizId;
	/**
	 * 发送方式：0自动；1手动
	 */
	@ExcelAttribute(name = "发送方式：0自动；1手动")
	@ExcelProperty("发送方式：0自动；1手动")
	@Schema(description = "发送方式：0自动；1手动")
	private Integer sendMethod;
	/**
	 * 短信回执内容
	 */
	@ExcelAttribute(name = "短信回执内容", maxLength = 100)
	@Length(max = 100, message = "短信回执内容不能超过100个字符")
	@ExcelProperty("短信回执内容")
	@Schema(description = "短信回执内容")
	private String message;

}
