package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.EmployeeRegistrationPre;
import com.yifu.cloud.plus.v1.yifu.archives.service.EmployeeRegistrationPreService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreSearchVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.SendMessageUpdateVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.MenuUtil;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

/**
 * 入职待建档表
 *
 * @author huych
 * @date 2025-03-12 17:14:19
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/employeeregistrationpre" )
@Tag(name = "入职待建档表管理")
public class EmployeeRegistrationPreController {

    private final EmployeeRegistrationPreService employeeRegistrationPreService;

	private final MenuUtil menuUtil;

    /**
     * 简单分页查询
     * @param page 分页对象
     * @param employeeRegistrationPre 入职待建档表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<EmployeeRegistrationPre>> getEmployeeRegistrationPrePage(Page<EmployeeRegistrationPre> page, EmployeeRegistrationPreSearchVo employeeRegistrationPre) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, employeeRegistrationPre);
		return new R<>(employeeRegistrationPreService.getEmployeeRegistrationPrePage(page,employeeRegistrationPre));
    }

    /**
     * 通过id查询入职待建档表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询")
    @GetMapping("/{id}" )
    public R<EmployeeRegistrationPre> getById(@PathVariable("id" ) String id) {
        return R.ok(employeeRegistrationPreService.getById(id));
    }

    /**
     * 新增入职待建档表
     * @param employeeRegistrationPre 入职待建档表
     * @return R
     */
    @Operation(summary = "新增入职待建档表", description = "新增入职待建档表")
    @SysLog("新增入职待建档表" )
    @PostMapping
    public R<Boolean> save(@RequestBody EmployeeRegistrationPre employeeRegistrationPre) {
        return R.ok(employeeRegistrationPreService.save(employeeRegistrationPre));
    }

    /**
     * 修改入职待建档表
     * @param employeeRegistrationPre 入职待建档表
     * @return R
     */
    @Operation(summary = "修改入职待建档表", description = "修改入职待建档表")
    @SysLog("修改入职待建档表" )
	@PostMapping("/updateById")
    public R updateById(@RequestBody EmployeeRegistrationPre employeeRegistrationPre) {
        return employeeRegistrationPreService.updateRegistById(employeeRegistrationPre);
    }

    /**
     * 入职待建档表 批量导出
     * @author huych
     * @date 2025-03-12 17:14:19
     **/
    @Operation(description = "导出入职待建档表")
    @PostMapping("/export")
    public void export(HttpServletResponse response, @RequestBody EmployeeRegistrationPreSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		employeeRegistrationPreService.listExport(response,searchVo);
    }

	/**
	 * 入职确认信息 批量导出
	 * @author huych
	 * @date 2025-03-17 16:26:26
	 **/
	@Operation(description = "导出入职确认信息")
	@PostMapping("/confirmExport")
	public void confirmExport(HttpServletResponse response, @RequestBody EmployeeRegistrationPreSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		employeeRegistrationPreService.confirmExport(response,searchVo);
	}

	/**
	 * @Author huyc
	 * @Description 新增入职待建档信息
	 * @Date 14:34 2025/3/14
	 **/
	@Inner
	@PostMapping("/inner/saveRegistPreInfo")
	public Boolean saveRegistPreInfo(@RequestBody EmployeeRegistrationPreVo preVo) {
		return employeeRegistrationPreService.saveRegistPreInfo(preVo);
	}

	/**
	 * 入职确认信息信息修改
	 * @param employeeRegistrationPre 入职确认信息
	 * @return R
	 */
	@Operation(summary = "入职确认信息信息修改", description = "入职确认信息信息修改")
	@SysLog("修改入职待建档表" )
	@PostMapping("/updateCommonInfo")
	public R updateCommonInfo(@RequestBody EmployeeRegistrationPre employeeRegistrationPre) {
		return employeeRegistrationPreService.updateCommonInfo(employeeRegistrationPre);
	}

	/**
	 * 入职确认信息信息修改
	 * @param searchVo type 查询类型 1待办列表 2 监控列表
	 * @return R
	 */
	@Operation(summary = "查询各个tab页签的入职待办条数", description = "查询各个tab页签的入职待办条数")
	@SysLog("查询各个tab页签的入职待办条数" )
	@PostMapping("/getListCount")
	public R getListCount(@RequestBody EmployeeRegistrationPreSearchVo searchVo) {
		return employeeRegistrationPreService.getListCount(searchVo);
	}

	/**
	 * 入职待建档入职审核
	 * @param employeeRegistrationPre 入职待建档表
	 * @return R
	 */
	@Operation(summary = "入职待建档入职审核", description = "入职待建档入职审核")
	@SysLog("入职待建档入职审核" )
	@PostMapping("/registrationPreAudit")
	public R registrationPreAudit(@RequestBody EmployeeRegistrationPre employeeRegistrationPre) {
		return employeeRegistrationPreService.registrationPreAudit(employeeRegistrationPre);
	}

	/**
	 * 批量发送入职信息收集短信
	 * @param vo vo
	 * @return R
	 */
	@Operation(summary = "批量发送入职信息收集短信", description = "批量发送入职信息收集短信")
	@SysLog("批量发送入职信息收集短信" )
	@PostMapping("/batchSms")
	public R batchSendMessage(@RequestBody SendMessageUpdateVo vo) {
		return employeeRegistrationPreService.batchSendMessage(vo);
	}
}
