package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.EmployeeRegistrationPre;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreExportVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreInfoExportVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreSearchVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.MessageTempleteVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 入职待建档表
 *
 * @author huych
 * @date 2025-03-12 17:14:19
 */
@Mapper
public interface EmployeeRegistrationPreMapper extends BaseMapper<EmployeeRegistrationPre> {
    /**
     * 入职待建档表简单分页查询
     * @param employeeRegistrationPre 入职待建档表
     * @return
     */
    IPage<EmployeeRegistrationPre> getEmployeeRegistrationPrePage(Page<EmployeeRegistrationPre> page, @Param("employeeRegistrationPre") EmployeeRegistrationPre employeeRegistrationPre);
	/**
	 * 入职待建档表导出数量查询
	 * @param searchVo 导出查询vo
	 * @return
	 */
	long selectExportCount(@Param("employeeRegistrationPre") EmployeeRegistrationPreSearchVo searchVo);
	/**
	 * 入职待建档表导出列表查询
	 * @param searchVo 导出查询vo
	 * @return
	 */
	List<EmployeeRegistrationPreExportVo> selectExportList(@Param("employeeRegistrationPre") EmployeeRegistrationPreSearchVo searchVo);

	/**
	 * 入职确认信息导出列表查询
	 * @param searchVo 导出查询vo
	 * @return
	 */
	List<EmployeeRegistrationPreInfoExportVo> selectConfirmExportList(@Param("employeeRegistrationPre") EmployeeRegistrationPreSearchVo searchVo);

	MessageTempleteVo selectTempleteVo(@Param("id") String id);
}
