package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.EmployeeRegistrationPre;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreSearchVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.SendMessageUpdateVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import javax.servlet.http.HttpServletResponse;

/**
 * 入职待建档表
 *
 * @author huych
 * @date 2025-03-12 17:14:19
 */
public interface EmployeeRegistrationPreService extends IService<EmployeeRegistrationPre> {
    /**
     * 入职待建档表简单分页查询
     * @param employeeRegistrationPre 入职待建档表
     * @return
     */
    IPage<EmployeeRegistrationPre> getEmployeeRegistrationPrePage(Page<EmployeeRegistrationPre> page, EmployeeRegistrationPreSearchVo employeeRegistrationPre);

	/**
	 * 入职待建档表导出
	 * @param searchVo 入职待建档导出查询vo
	 * @return
	 */
    void listExport(HttpServletResponse response, EmployeeRegistrationPreSearchVo searchVo);

	/**
	 * 入职确认信息导出
	 * @param searchVo 入职确认信息导出查询vo
	 * @return
	 */
	void confirmExport(HttpServletResponse response, EmployeeRegistrationPreSearchVo searchVo);


	/**
	 * 新增入职待建档信息
	 * @param preVo 新增入职待建档vo
	 * @return
	 */
    Boolean saveRegistPreInfo(EmployeeRegistrationPreVo preVo);

	/**
	 * 拒绝入职
	 * @param employeeRegistrationPre 入职待建档表
	 * @return
	 */
    R updateRegistById(EmployeeRegistrationPre employeeRegistrationPre);

	/**
	 * 入职确认信息信息修改
	 * @param employeeRegistrationPre 入职确认信息表
	 * @return
	 */
	R updateCommonInfo(EmployeeRegistrationPre employeeRegistrationPre);

	/**
	 * 入职确认信息信息修改
	 * @param searchVo  type 查询类型 1待办列表 2 监控列表
	 * @return
	 */
	R getListCount(EmployeeRegistrationPreSearchVo searchVo);

	/**
	 * 查询预入职待审核数据
	 * @param pre 入职待建档表
	 * @return
	 */
	R registrationPreAudit(EmployeeRegistrationPre pre);

	/**
	 * 批量发送短信
	 * @param vo
	 * @return
	 */
	R batchSendMessage(SendMessageUpdateVo vo);

	void updatePreStatusToEnd(String deptNo, String EmpIdcard);
}
