package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationDaprCountVo;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationUpdateVo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.*;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.EmployeeRegistrationPreMapper;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TCompleteMonitorMapper;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TEmployeeInfoMapper;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TPreEmpMainMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.*;
import com.yifu.cloud.plus.v1.yifu.archives.vo.*;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CacheConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ClientNameConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.*;
import com.yifu.cloud.plus.v1.yifu.common.core.util.alisms.AliSmsResult;
import com.yifu.cloud.plus.v1.yifu.common.core.util.alisms.RegistParamVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.alisms.YiFuSmsUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.CspDaprUtils;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.MenuUtil;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.util.*;

/**
 * 入职待建档表
 *
 * @author huych
 * @date 2025-03-12 17:14:19
 */
@Log4j2
@Service
@RequiredArgsConstructor
public class EmployeeRegistrationPreServiceImpl extends ServiceImpl<EmployeeRegistrationPreMapper, EmployeeRegistrationPre> implements EmployeeRegistrationPreService {

	@Autowired
	private CspDaprUtils cspDaprUtils;

	@Autowired
	private TEmployeeLogService tEmployeeLogService;

	private final TCompleteMonitorMapper completeMonitorMapper;

	private final TSettleDomainService tSettleDomainService;

	private final TPreEmpMainMapper empMainMapper;

	private final TRegistWarningEmployeeService employeeService;

	private final TEmployeeInfoMapper employeeInfoMapper;

	private final MenuUtil menuUtil;

    /**
     * 入职待建档表简单分页查询
     * @param employeeRegistrationPre 入职待建档表
     * @return
     */
    @Override
    public IPage<EmployeeRegistrationPre> getEmployeeRegistrationPrePage(Page<EmployeeRegistrationPre> page, EmployeeRegistrationPreSearchVo employeeRegistrationPre){
		//权限赋值
		initSearchVo(employeeRegistrationPre);
		if (Common.isEmpty(employeeRegistrationPre.getStatusList())
				&& !CommonConstants.THREE_STRING.equals(employeeRegistrationPre.getType())) {
			employeeRegistrationPre.setStatusList(CommonConstants.processPreArchivesStatus);
		}
		return baseMapper.getEmployeeRegistrationPrePage(page,employeeRegistrationPre);
    }

    /**
     * 入职待建档表批量导出
     * @param searchVo 入职待建档表
     * @return
     */
    @Override
    public void listExport(HttpServletResponse response, EmployeeRegistrationPreSearchVo searchVo){
        String fileName = "入职待建档表批量导出" + DateUtil.getThisTime() + ".xlsx";
        //获取要导出的列表
        List<EmployeeRegistrationPreExportVo> list = new ArrayList<>();
		//权限赋值
		initSearchVo(searchVo);
		if (Common.isEmpty(searchVo.getStatusList())
				&& !CommonConstants.THREE_STRING.equals(searchVo.getType())) {
			searchVo.setStatusList(CommonConstants.processPreArchivesStatus);
		}
        long count = baseMapper.selectExportCount(searchVo);
        try (ServletOutputStream out= response.getOutputStream();){
            response.setContentType(CommonConstants.MULTIPART_FORM_DATA);
            response.setCharacterEncoding("utf-8");
            response.setHeader(CommonConstants.CONTENT_DISPOSITION, CommonConstants.ATTACHMENT_FILENAME + URLEncoder.encode(fileName  , CommonConstants.UTF8));
            // 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
			ExcelUtil<EmployeeRegistrationPreExportVo> util = new ExcelUtil<>(EmployeeRegistrationPreExportVo.class);
			// 获取所有字典type
			Map<String,String> nameAndDicTypeMap = util.getConverterDicType();
			// 获取所有字典对应的值
			Map<String,String> redisLabelMap = (Map<String, String>) RedisUtil.redis.opsForValue().get(CacheConstants.REDIS_DICT_LABLE);
			Set<String> exportFields = new HashSet<>(Arrays.asList("deptName", "deptNo", "employeeName", "empIdcard",
					"empPhone", "joinLeaveDate", "empNature", "contractType", "dataSource", "customerUsernameNew", "expectedCollectionTime", "processStatus"));
			// 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
			ExcelWriter excelWriter = EasyExcel.write(out, EmployeeRegistrationPreExportVo.class)
					.registerConverter(new DictConverter(nameAndDicTypeMap,redisLabelMap))
					.includeColumnFieldNames(exportFields).build();

			int index = 0;
            if (count >  CommonConstants.ZERO_INT){
                for (int i = 0; i <= count; i += CommonConstants.EXCEL_EXPORT_LIMIT) {
                    // 获取实际记录
                    searchVo.setLimitStart(i);
                    searchVo.setLimitEnd(CommonConstants.EXCEL_EXPORT_LIMIT);
                    list = baseMapper.selectExportList(searchVo);
                    if (Common.isNotNull(list)){
                        WriteSheet writeSheet = EasyExcel.writerSheet("入职待建档表"+index).build();
                        excelWriter.write(list,writeSheet);
                        index++;
                    }
                    if (Common.isNotNull(list)){
                        list.clear();
                    }
                }
            }else {
                WriteSheet writeSheet = EasyExcel.writerSheet("入职待建档表"+index).build();
                excelWriter.write(list,writeSheet);
            }
            if (Common.isNotNull(list)){
                list.clear();
            }
            excelWriter.finish();
        }catch (Exception e){
            log.error("执行异常" ,e);
        }
    }

	/**
	 * 入职确认信息批量导出
	 * @param searchVo 入职待建档表
	 * @return
	 */
	@Override
	public void confirmExport(HttpServletResponse response, EmployeeRegistrationPreSearchVo searchVo){
		String fileName = "入职确认信息批量导出" + DateUtil.getThisTime() + ".xlsx";
		//获取要导出的列表
		List<EmployeeRegistrationPreInfoExportVo> list = new ArrayList<>();
		//权限赋值
		initSearchVo(searchVo);
		if (Common.isEmpty(searchVo.getStatusList())
				&& !CommonConstants.THREE_STRING.equals(searchVo.getType())) {
			searchVo.setStatusList(CommonConstants.processPreArchivesStatus);
		}
		long count = baseMapper.selectExportCount(searchVo);
		try (ServletOutputStream out= response.getOutputStream();){
			response.setContentType(CommonConstants.MULTIPART_FORM_DATA);
			response.setCharacterEncoding("utf-8");
			response.setHeader(CommonConstants.CONTENT_DISPOSITION, CommonConstants.ATTACHMENT_FILENAME + URLEncoder.encode(fileName  , CommonConstants.UTF8));
			// 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
			ExcelUtil<EmployeeRegistrationPreInfoExportVo> util = new ExcelUtil<>(EmployeeRegistrationPreInfoExportVo.class);
			// 获取所有字典type
			Map<String,String> nameAndDicTypeMap = util.getConverterDicType();
			// 获取所有字典对应的值
			Map<String,String> redisLabelMap = (Map<String, String>) RedisUtil.redis.opsForValue().get(CacheConstants.REDIS_DICT_LABLE);
			Set<String> exportFields = new HashSet<>(Arrays.asList("deptName", "deptNo", "employeeName", "empIdcard",
					"empPhone", "position","joinLeaveDate", "confirmUser", "confirmTime", "serverItem", "empNature",
					"contractType", "fileAdress"));
			// 这里 需要指定写用哪个class去写，然后写到第一个sheet，然后文件流会自动关闭
			ExcelWriter excelWriter = EasyExcel.write(out, EmployeeRegistrationPreInfoExportVo.class)
					.registerConverter(new DictConverter(nameAndDicTypeMap,redisLabelMap))
					.includeColumnFieldNames(exportFields).build();

			int index = 0;
			if (count >  CommonConstants.ZERO_INT){
				for (int i = 0; i <= count; i += CommonConstants.EXCEL_EXPORT_LIMIT) {
					// 获取实际记录
					searchVo.setLimitStart(i);
					searchVo.setLimitEnd(CommonConstants.EXCEL_EXPORT_LIMIT);
					list = baseMapper.selectConfirmExportList(searchVo);
					if (Common.isNotNull(list)){
						WriteSheet writeSheet = EasyExcel.writerSheet("入职确认信息表"+index).build();
						excelWriter.write(list,writeSheet);
						index++;
					}
					if (Common.isNotNull(list)){
						list.clear();
					}
				}
			}else {
				WriteSheet writeSheet = EasyExcel.writerSheet("入职确认信息表"+index).build();
				excelWriter.write(list,writeSheet);
			}
			if (Common.isNotNull(list)){
				list.clear();
			}
			excelWriter.finish();
		}catch (Exception e){
			log.error("执行异常" ,e);
		}
	}

	@Override
	public Boolean saveRegistPreInfo(EmployeeRegistrationPreVo preVo) {
		EmployeeRegistrationPre pre = new EmployeeRegistrationPre();
		BeanUtils.copyProperties(pre,preVo);
		baseMapper.insert(pre);
		return true;
	}

	@Override
	public R updateRegistById(EmployeeRegistrationPre employeeRegistrationPre) {
		EmployeeRegistrationPre updatePre = baseMapper.selectById(employeeRegistrationPre.getId());
		if (Common.isEmpty(updatePre) || (updatePre.getProcessStatus().equals(CommonConstants.THREE_STRING)
				|| updatePre.getProcessStatus().equals(CommonConstants.FOUR_STRING))) {
			return R.failed(CommonConstants.NO_DATA_TO_HANDLE);
		}
		YifuUser user = SecurityUtils.getUser();
		employeeRegistrationPre.setProcessStatus(CommonConstants.THREE_STRING);
		baseMapper.updateById(employeeRegistrationPre);
		//新增操作记录
		EmployeeRegistrationUpdateVo receiveVo = new EmployeeRegistrationUpdateVo();
		receiveVo.setEmployeeName(user.getNickname());
		receiveVo.setEmpIdcard(updatePre.getEmpIdcard());
		receiveVo.setReason(employeeRegistrationPre.getReason());
		receiveVo.setDeptNo(employeeRegistrationPre.getDeptNo());
		try {
			//调用csp服务更新状态和新增操作记录
			cspDaprUtils.updateRegistByPreInfo(receiveVo);
		} catch (Exception e) {
			log.error("调用csp服务更新数据异常", e);
		}
		return R.ok();
	}

	@Override
	public R updateCommonInfo(EmployeeRegistrationPre employeeRegistrationPre) {
		EmployeeRegistrationPre updatePre = baseMapper.selectById(employeeRegistrationPre.getId());
		if (Common.isEmpty(updatePre)) {
			return R.failed(CommonConstants.NO_DATA_TO_HANDLE);
		}
		//旧的对象，用来对比变更参数
		EmployeeRegistrationPre comparePre = baseMapper.selectById(employeeRegistrationPre.getId());
		//操作记录中字典值的转化
		String natureItemBefore = null;
		String natureItemAfter = null;
		String contractItemBefore = null;
		String contractItemAfter = null;
		if (!updatePre.getContractType().equals(employeeRegistrationPre.getContractType())) {
			Map<String,String> dicObj = (Map<String, String>) RedisUtil.redis.opsForValue().get(
					CacheConstants.DICT_DETAILS + CommonConstants.COLON_STRING + "personnel_type");
			for (Map.Entry<String,String> entry:dicObj.entrySet()){
				if (Common.isNotNull(entry.getKey()) && entry.getKey().equals(updatePre.getContractType())){
					contractItemBefore = entry.getValue();
					break;
				}
				if (Common.isNotNull(entry.getKey()) && entry.getKey().equals(employeeRegistrationPre.getContractType())){
					contractItemAfter = entry.getValue();
					break;
				}
			}
		}
		if (!updatePre.getEmpNature().equals(employeeRegistrationPre.getEmpNature())) {
			Map<String,String> dicObj = (Map<String, String>) RedisUtil.redis.opsForValue().get(
					CacheConstants.DICT_DETAILS + CommonConstants.COLON_STRING + "emp_natrue");
			for (Map.Entry<String,String> entry:dicObj.entrySet()){
				if (Common.isNotNull(entry.getKey()) && entry.getKey().equals(updatePre.getEmpNature())){
					natureItemBefore = entry.getValue();
					break;
				}
				if (Common.isNotNull(entry.getKey()) && entry.getKey().equals(employeeRegistrationPre.getEmpNature())){
					natureItemAfter = entry.getValue();
					break;
				}
			}
		}
		YifuUser user = SecurityUtils.getUser();
		try {
			updatePre.setServerItem(employeeRegistrationPre.getServerItem());
			updatePre.setEmpNature(employeeRegistrationPre.getEmpNature());
			updatePre.setContractType(employeeRegistrationPre.getContractType());
			updatePre.setFileProvince(employeeRegistrationPre.getFileProvince());
			updatePre.setFileCity(employeeRegistrationPre.getFileCity());
			updatePre.setFileTown(employeeRegistrationPre.getFileTown());
			baseMapper.updateById(employeeRegistrationPre);
			if (null != natureItemBefore) {
				comparePre.setEmpNature(natureItemBefore);
			}
			if (null != natureItemAfter) {
				employeeRegistrationPre.setEmpNature(natureItemAfter);
			}
			if (null != contractItemBefore) {
				comparePre.setContractType(contractItemBefore);
			}
			if (null != contractItemAfter) {
				employeeRegistrationPre.setContractType(contractItemAfter);
			}
			tEmployeeLogService.saveModificationRecord(CommonConstants.dingleDigitIntArray[4],
					employeeRegistrationPre.getId(), "", comparePre, employeeRegistrationPre,user);
		} catch (Exception e) {
			log.error("生成入职待确认信息修改操作日志异常", e);
		}
		return R.ok();
	}

	@Override
	public R getListCount(EmployeeRegistrationPreSearchVo searchVo) {
		try {
			YifuUser user = SecurityUtils.getUser();
			//入职确认数量
			EmployeeRegistrationDaprCountVo vo = new EmployeeRegistrationDaprCountVo();
			vo.setUser(user);
			vo.setType(searchVo.getType());
			vo.setMId(searchVo.getMId());
			R<EmployeeRegistrationDaprCountVo> daprVo = cspDaprUtils.getRegisterPreCount(vo);
			if (Common.isNotNull(daprVo) && Common.isNotNull(daprVo.getData())) {
				vo = daprVo.getData();
			}
			//入职待确认数量
			long countOne = vo.getCount();

			//入职待建档数量
			menuUtil.setAuthSql(user, searchVo);
			initSearchVo(searchVo);
			searchVo.setStatusList(CommonConstants.processPreArchivesStatus);
			long countTwo = baseMapper.selectExportCount(searchVo);

			//档案待完整数量
			long countThree = completeMonitorMapper.getAllLackArchivesExportCount(searchVo);
			EmployeeRegistrationCountVo countVo = new EmployeeRegistrationCountVo();
			countVo.setTypeOneCount(countOne);
			countVo.setTypeTwoCount(countTwo);
			countVo.setTypeThreeCount(countThree);
			countVo.setTotalCount(countOne + countTwo + countThree);
			return R.ok(countVo);
		} catch (Exception e) {
			log.error("生成入职待确认信息修改操作日志异常", e);
			return R.failed(CommonConstants.RESULT_DATA_FAIL);
		}
	}

	@Override
	public R registrationPreAudit(EmployeeRegistrationPre pre) {
		TPreEmpMain empMain = empMainMapper.selectOne(Wrappers.<TPreEmpMain>query().lambda()
				.eq(TPreEmpMain::getEmpIdcard,pre.getEmpIdcard())
				.eq(TPreEmpMain::getDeptId,pre.getDeptId())
				.eq(TPreEmpMain::getStatus,CommonConstants.TWO_STRING)
				.last(CommonConstants.LAST_ONE_SQL));
		if (Common.isEmpty(empMain)) {
			return R.failed(CommonConstants.NO_DATA_TO_HANDLE);
		}
		return R.ok(empMain.getId());
	}

	@Override
	public R batchSendMessage(SendMessageUpdateVo vo) {
		//获取短信待发放和信息待填写的数据
		List<String> idList = vo.getIdList();
		RegistParamVo paramVo = new RegistParamVo();
		List<TRegistWarningEmployee> smsEmployeeList = new ArrayList<>();
		List<EmployeeRegistrationPre> updateList = new ArrayList<>();
		List<RegistParamVo> params = new ArrayList<>();
		List<String> phones = new ArrayList<>();
		if (CommonConstants.ONE_STRING.equals(vo.getType())) {
			List<EmployeeRegistrationPre> updatePreList = baseMapper.selectList(Wrappers.<EmployeeRegistrationPre>query()
					.lambda().in(EmployeeRegistrationPre::getId, idList)
					.in(EmployeeRegistrationPre::getProcessStatus, CommonConstants.processStatus));
			if (null == updatePreList || updatePreList.isEmpty()) {
				return R.failed(CommonConstants.NO_DATA_TO_HANDLE);
			}
			for (EmployeeRegistrationPre updatePre : updatePreList) {
				paramVo.setName(updatePre.getEmployeeName());
				paramVo.setLinkValue("additional.html#/quick-onboarding?" + "?empId=" + updatePre.getId());
				params.add(paramVo);
				phones.add(updatePre.getEmpPhone());
				if (CommonConstants.ONE_STRING.equals(updatePre.getProcessStatus())) {
					updatePre.setProcessStatus(CommonConstants.TWO_STRING);
				}
				updateList.add(updatePre);
			}
		} else {
			List<TEmployeeInfo> infoList = employeeInfoMapper.selectList(Wrappers.<TEmployeeInfo>query()
					.lambda().in(TEmployeeInfo::getId, idList));
			if (null == infoList || infoList.isEmpty()) {
				return R.failed(CommonConstants.NO_DATA_TO_HANDLE);
			}
			for (TEmployeeInfo info : infoList) {
				paramVo.setName(info.getEmpName());
				paramVo.setLinkValue("additional.html#/quick-onboarding?" + "?empId=" + info.getId());
				params.add(paramVo);
				phones.add(info.getEmpPhone());
				//如果有入职待建档数据同步更新
				EmployeeRegistrationPre registrationPre = baseMapper.selectOne(Wrappers.<EmployeeRegistrationPre>query().lambda()
						.eq(EmployeeRegistrationPre::getEmpIdcard,info.getEmpIdcard())
						.eq(EmployeeRegistrationPre::getDeptNo,vo.getDeptNo())
						.eq(EmployeeRegistrationPre::getProcessStatus,CommonConstants.ZERO_STRING)
						.last(CommonConstants.LAST_ONE_SQL));
				if (Common.isNotNull(registrationPre)) {
					registrationPre.setProcessStatus(CommonConstants.TWO_STRING);
				}
				updateList.add(registrationPre);
			}
		}
		//发送短信
		AliSmsResult res = sendMessage(phones, params);
		if (null != res && null != res.getBizId()) {
			this.updateBatchById(updateList);
			for(EmployeeRegistrationPre updatePre: updateList) {
				//生成短信发送的记录
				TRegistWarningEmployee smsEmployee = new TRegistWarningEmployee();
				smsEmployee.setWarningId(updatePre.getId());
				smsEmployee.setEmpName(updatePre.getEmployeeName());
				smsEmployee.setEmpPhone(updatePre.getEmpPhone());
				smsEmployee.setSendDate(DateUtil.getCurrentDateTime());
				smsEmployee.setSendMethod(CommonConstants.ONE_INT);
				smsEmployeeList.add(smsEmployee);
			}
			employeeService.saveBatch(smsEmployeeList);
			return R.ok();
		} else {
			return R.failed();
		}
	}

	@Override
	public void updatePreStatusToEnd(String deptNo, String EmpIdcard) {
		EmployeeRegistrationPre registrationPre = baseMapper.selectOne(Wrappers.<EmployeeRegistrationPre>query().lambda()
				.eq(EmployeeRegistrationPre::getEmpIdcard,EmpIdcard)
				.eq(EmployeeRegistrationPre::getDeptNo,deptNo)
				.in(EmployeeRegistrationPre::getProcessStatus,CommonConstants.processPreArchivesStatus)
				.last(CommonConstants.LAST_ONE_SQL));
		if (Common.isNotNull(registrationPre)) {
			registrationPre.setProcessStatus(CommonConstants.FOUR_STRING);
			baseMapper.updateById(registrationPre);
		}
	}

	/**
	 * @Description: 获取前端客服的所有项目权限
	 * @Author: huych
	 * @Date: 2025/3/13 17:02
	 * @return:
	 **/
	public void initSearchVo(EmployeeRegistrationPreSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		long roleId = 1839501715787390978L;
		boolean isSsc = this.haveRole(user, roleId);
		if (isSsc || CommonConstants.ZERO_STRING.equals(user.getSystemFlag())) {
			searchVo.setAuthSql(null);
			return;
		}
		if (Common.isNotNull(searchVo.getType()) && CommonConstants.ONE_STRING.equals(searchVo.getType())) {
			searchVo.setAuthSql(null);
			//获取项目信息
			List<String> deptNos = tSettleDomainService.getAllDeptByCustomerLoginName(user.getUsername());
			if (null != deptNos && !deptNos.isEmpty()) {
				searchVo.setDeptNoList(deptNos);
			} else {
				searchVo.setId(CommonConstants.ONE_STRING_NEGATE);
			}
		}
	}

	/**
	 * @Description: 批量发送短信
	 * @Author: huych
	 * @Date: 2025/3/18 17:02
	 * @return:
	 **/
	public AliSmsResult sendMessage (List<String> phones,List<RegistParamVo> params ) {
		List<String> signNames = new ArrayList<>();
		MessageTempleteVo templeteVo = baseMapper.selectTempleteVo(CommonConstants.ONE_STRING);
		for (int i=0;i<phones.size();i++){
			signNames.add(templeteVo.getSignName());
		}
		return YiFuSmsUtil.sendRegistBatchSms(phones, params, signNames, templeteVo.getTempleteCode());
	}


	public boolean haveRole(YifuUser user, long roleId) {
		List<Long> roleList = user.getClientRoleMap().get(ClientNameConstants.CLIENT_MVP);
		for (Long role : roleList) {
			if (role == roleId) {
				return true;
			}
		}
		return false;
	}

}
