package com.yifu.cloud.plus.v1.business.entity.cert;

import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 人员证书信息表
 *
 * @author fxj
 * @date 2021-08-16 15:34:16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_cert_info")
@Schema(description = "人员证书信息表")
public class TCertInfo extends Model<TCertInfo> {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description = "主键")
    private String id;
    /**
     * b端员工工号 （电信工号）
     */
    @ExcelAttribute(name = "电信工号", maxLength = 20, isNotEmpty = true, errorInfo = "电信工号不可为空")
    @Schema(description = "电信工号")
    private String businessTelecomNumber;
    /**
     * 姓名
     */
    @ExcelAttribute(name = "姓名", isNotEmpty = true, errorInfo = "姓名不能为空", maxLength = 50)
    @Schema(description = "姓名")
    private String empName;
    /**
     * 员工身份证号
     */
    @ExcelAttribute(name = "身份证号", maxLength = 20, isNotEmpty = true, errorInfo = "身份证号不可为空")
    @Schema(description = "身份证号")
    private String empIdcard;
    /**
     * 部门
     */
    @ExcelAttribute(name = "所属部门", maxLength = 20)
    @Schema(description = "所属部门")
    private String organId;

    /**
     * 岗位
     */
    @ExcelAttribute(name = "岗位", maxLength = 20)
    @Schema(description = "岗位")
    private String post;

    /**
     * 标签
     */
    @ExcelAttribute(name = "标签名称", maxLength = 20)
    @Schema(description = "标签名称")
    private String label;
    /**
     * 证件类型：电工证、登高证等
     */
    @ExcelAttribute(name = "证件类型", maxLength = 32, isNotEmpty = true, errorInfo = "证件类型不可为空", isDataId = true, dataType = "cert_type")
    @Schema(description = "证件类型")
    private String certType;
    /**
     * 证件状态：0正常、1待复审、2已失效
     */
    @ExcelAttribute(name = "证件状态",  errorInfo = "证件状态不能为空", isDataId = true, dataType = "cert_status")
    @Schema(description = "证件状态(0 正常  1  待复审  2 已失效)")
    private String status;
    /**
     * 证书号
     */
    @ExcelAttribute(name = "证件号", maxLength = 50, isNotEmpty = true, errorInfo = "证件号不能为空")
    @Schema(description = "证件号")
    private String certNum;
    /**
     * 作业类别
     */
    @ExcelAttribute(name = "作业类别", maxLength = 50, isNotEmpty = true, errorInfo = "作业类别不能为空")
    @Schema(description = "作业类别")
    private String jobClass;
    /**
     * 准操项目
     */
    @ExcelAttribute(name = "准操项目", maxLength = 100, errorInfo = "准操项目不能为空")
    @Schema(description = "准操项目")
    private String operationItem;

    /**
     * 初领日期
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    @ExcelAttribute(name = "初领日期", maxLength = 20,  errorInfo = "初领日期不能为空")
    @Schema(description = "初领日期")
    private LocalDate receiveTime;
    /**
     * 有效期限
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    @ExcelAttribute(name = "有效期-开始日", maxLength = 50,  errorInfo = "有效期-开始日不能为空")
    @Schema(description = "有效期-开始日")
    private LocalDate termValidityStart;

    /**
     * 有效期限
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    @ExcelAttribute(name = "有效期-截止日", maxLength = 50,  errorInfo = "有效期-截止日不能为空")
    @Schema(description = "有效期-截止日")
    private LocalDate termValidityEnd;
    /**
     * 复审日期
     */
    @ExcelAttribute(name = "复审日期", isNotEmpty = true, errorInfo = "复审日期不能为空")
    @Schema(description = "复审日期")
    private LocalDate reviewDate;
    /**
     * 证件照片地址-正面
     */
    @ExcelAttribute(name = "证件照片地址-正面", maxLength = 100)
    @Schema(description = "证件照片地址-正面")
    private String ossUrlFront;
    /**
     * 证件照片地址-反面
     */
    @ExcelAttribute(name = "证件照片地址-反面", maxLength = 100)
    @Schema(description = "证件照片地址-反面")
    private String ossUrlBack;
    /**
     * 创建人姓名
     */
    @ExcelAttribute(name = "创建人姓名", maxLength = 20)
    @Schema(description = "创建人姓名")
    private String createUser;
    /**
     * 创建时间
     */
    @ExcelAttribute(name = "创建时间")
    @Schema(description = "创建时间")
    private LocalDateTime createTime;
    /**
     * 删除状态：0未删除 1删除
     */
    @ExcelAttribute(name = "删除状态", errorInfo = "删除状态不能为空")
    @Schema(description = "删除状态")
    private String deleteFlag;
}
