package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.alibaba.fastjson.JSON;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysUser;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.*;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprUpmsProperties;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

/**
 * @Author huyc
 * @Date 2022-07-18
 * @Description
 * @Version 1.0
 */
@Log4j2
@EnableConfigurationProperties(DaprUpmsProperties.class)
public class UpmsDaprUtils {

	@Autowired
	private DaprUpmsProperties daprUpmsProperties;

	/**
	 * 获取所有区域数据
	 * @Author huyc
	 * @Date 2022-07-18
	 * @return
	 **/
	public R<AreaVo> getAreaListR() {
		R<AreaVo> areaListR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/area/inner/getAreaVo","", AreaVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(areaListR)){
			return R.failed("获取所有区域数据失败！");
		}
		return areaListR;
	}
	/**
	 * 获取所有区域数据
	 * @Author huyc
	 * @Date 2022-07-18
	 * @return
	 **/
	public R<AreaMap> getAreaMapR() {
		R<AreaMap> areaListR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/area/inner/getAreaMap","", AreaMap.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(areaListR)){
			return R.failed("获取所有区域数据失败！");
		}
		return areaListR;
	}

	/**
	 * @Author fxj
	 * @Description 获取所有用户数据
	 * @Date 17:57 2022/8/16
	 * @Param
	 * @return
	**/
	public R<AllUserNaVo> getAllUserName() {
		R<AllUserNaVo> allUserVoR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/getAllUserName","", AllUserNaVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(allUserVoR)){
			return R.failed("获取所有用户数据失败！");
		}
		return allUserVoR;
	}

	/**
	 * @Author fxj
	 * @Description 获取所有用户数据
	 * @Date 17:57 2022/8/16
	 * @Param
	 * @return
	 **/
	public R<AllUserNaVo> getAllUserIds() {
		R<AllUserNaVo> allUserVoR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/getAllUserIdDTO","", AllUserNaVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(allUserVoR)){
			return R.failed("获取所有用户数据失败！");
		}
		return allUserVoR;
	}

	/**
	 * @Author fxj
	 * @Description 获取指定用户名对应用户IDs
	 * @Date 17:57 2022/8/16
	 * @Param
	 * @return
	 **/
	public R<SysUserListVo> getUserIdsByUserNames(String usernames) {
		R<SysUserListVo> allUserVoR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/getUserIdsByUserNames", usernames, SysUserListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(allUserVoR)){
			return R.failed("获取指定用户名对应用户IDs失败！");
		}
		return allUserVoR;
	}
	/**
	 * @Author fxj
	 * @Description 通过用户ID 获取 在用的MVP系统的用户
	 * @Date 17:24 2025/3/12
	**/
	public R<SysUsersVo> getUserVoByUserIds(String userIds) {
		R<SysUsersVo> allUserVoR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/getUserVoByUserIds", userIds, SysUsersVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(allUserVoR)){
			return R.failed("获取指定用户IDS对应用户信息失败！");
		}
		return allUserVoR;
	}
	public R<SysUser> getSimpleUser(String userId) {
		R<SysUser> userR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/getSimpleUser",userId, SysUser.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(userR)){
			return R.failed("获取所有用户数据失败！");
		}
		return userR;
	}

	public R<SysUser> getSimpleUserByLoginName(String loginName) {
		R<SysUser> userR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/getSimpleUserByLoginName",loginName, SysUser.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(userR)){
			return R.failed("获取所有用户数据失败！");
		}
		return userR;
	}

	public R<SysUserListVo> getUserByRoleIdForCrm(UserApprovalRoleVO userByApprovalRole) {
		R<SysUserListVo> allUserVoR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/getUser/getUserByRoleIdForCrm",userByApprovalRole, SysUserListVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(allUserVoR)){
			return R.failed("查询流程配置审批角色对应的审批人失败！");
		}
		return allUserVoR;
	}

	/**
	 * @Author huyc
	 * @Description 判断部门是否属于分公司
	 * @Date 10:38 2025/1/20
	 * @Param
	 * @return
	 **/
	public R<Boolean> selectExitDeptCompany(String deptId) {
		return HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/selectExitDeptCompany", deptId, Boolean.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 判断部门是否属于分公司
	 * @Date 10:38 2025/1/20
	 * @Param
	 * @return
	 **/
	public R<SysCspDeptVo> selectCspDeptByUserDeptId(SysCspDeptVo vo) {
		return HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/user/inner/selectInnerCspDeptByUserDeptId", vo, SysCspDeptVo.class, SecurityConstants.FROM_IN);
	}
}
