package com.yifu.cloud.plus.v1.ekp.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcApiException;
import com.icbc.api.IcbcConstants;
import com.icbc.api.request.*;
import com.icbc.api.response.*;
import com.yifu.cloud.plus.v1.ekp.config.EkpEntryProperties;
import com.yifu.cloud.plus.v1.ekp.config.IcbcConfigProperties;
import com.yifu.cloud.plus.v1.ekp.entity.EkpBankCodeSet;
import com.yifu.cloud.plus.v1.ekp.entity.EkpSocialInfo;
import com.yifu.cloud.plus.v1.ekp.mapper.EkpSocialInfoMapper;
import com.yifu.cloud.plus.v1.ekp.service.EkpBankCodeSetService;
import com.yifu.cloud.plus.v1.ekp.service.IcbcTransactionFlowQueryService;
import com.yifu.cloud.plus.v1.ekp.vo.EKPEntryPushParam;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import io.micrometer.core.instrument.util.StringUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 聚富通到账通知交易流水查询
 *
 * @author huyc
 * @date 2024-05-23 11:21:56
 */
@Log4j2
@Service
@RequiredArgsConstructor
@EnableConfigurationProperties({IcbcConfigProperties.class, EkpEntryProperties.class})
public class IcbcTransactionFlowQueryServiceImpl extends ServiceImpl<EkpSocialInfoMapper, EkpSocialInfo> implements IcbcTransactionFlowQueryService {

	@Autowired
	private IcbcConfigProperties icbcConfigProperties;

	@Autowired
	private EkpEntryProperties ekpEntryProperties;
	@Autowired
	private EkpBankCodeSetService ekpBankCodeSetService;

	@Override
	public R getIcbcTransactionFlow() {
//		//应用id 应用方私钥 网关公钥 应用方加密串
//		String APP_ID = "11000000000000028685";
//		//应用方私钥
//		String MY_PRIVATE_KEY = "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCEZYrhm3dBp3PqlMc9fBBEE8Tp8M34Yy6Ucs3FV/VahsdHaLe0kEPugf1twbt/hD4hdIwzUj/ZtG2BhusRiMptdlWtNKcIgFxaaFaKANKrIodeQjv0jjZvK9ugoQxmiM4gF5SGX2a847zohv/6TvAYiB9AI3tdKQTbj6I3pwmuO3cfzgU5IwepeguE4fxqnh7C19MEq4vXv0yBq/f43zQ2HBMS+KRgokNLUBqoEOyfaKkPL9ot+zISPwENQOLqQMZ1hczp5tEB2FeZecdzrzjeXkzPSy1ZJmNyNuOl+WG85aoeDJTQ7hx/g6KFA6zU2VBGUR7q4pXdGRslpa6KYETBAgMBAAECggEALkfElXqf5G5hocWiJAcDNJjog5JunX4mITREY9CMbrmgXYDofpDTfkMoUL6hCUEz6sPv4lzE/xgIE3gTIcz8Xek4p9Q480rTfbLtVU5WVgY65aMnjCROOOxO2MaTLCB0VVmIzLP6mNrPBUVzo48GdLzYl7YPgJA/J3T9EpEsXB/iAdjiv/VH9vOIW6WUlQUSceyNznf1rfwMJvHt7zb56IJGZMq9G6C5SUeqWbqbvNi+nL8yeu8fM/O/ERZJQBDwMXbRAPvhhcbDwVzpg4BRc7AVv0SLzy6ZA2+zLJmDe9F9uXmG6QQ4ra8mDqLeugDP9blKUOEm8JLIh7nzvhpNhQKBgQDK4ZEz1zui6GQsxsnbm24EvparfniPqDBS/V29MDZysXDmG123R22RA//BWC3m5cY+3vg0ayCGaXRrc9/V+u+jmwVfsR6XCM6WM2IZVVFBUzqKMlTKsZ4n3V/6pqBHG8++GUab5W6p/7NYI22xx0ZFObEt4EkaaaP7RzY6AVrtCwKBgQCnD6P24uR6VHN84lhyZl+iJW6azTd26AhaJ768wSl5rqN6N4AV9cXeAUKylPgMPvy+2mjNX7He0Oitb7/lrKK93/olmDQoHpqj1yZum8VVPiyEKk6qCoYYoHEloLPJDPRs6yiBjrO8oghHRuyJErKRN6IZC3Rq/mrXuDwrZYS84wKBgFn9wDisigly56xs6PD+esij+ZVMXhHq2rSVKlVW42/wgVGwZdt8VX9ztKiAgqve1BbjNFmcAytb74YSOgFic5Wwl6uglx8LiwdY93ShQY+maVsPhEj8jFjGe2JlMscX8QgzkfxowrOpdlXsMSYgbG0ccBkXWZXbsh8tsUH9g+WNAoGAbQ5avOo0uF603Uts7ZFC0Lia0Vcx499oxGG5s8Js7tBAS6I7bRp5xokQHz/8BRKBL52oWJklpgy+N6oBnU7rFgRGaZBITABedqIWppHtac4ihUyQ+ZPRIfZqpmOXuaFJVmjUkm6zimpD+TOlaX3ZL88fdDX0E3xuBtBwBuxIkH0CgYEAlXyBbG2/fVV/PDUVCAA+aeWstojR1ncDhJmFnENSk5I/y3mh+d+u4ZG3hmVQZfR1EYM+n9wPQ2LxqNpGPA8o4JK/MSfVKun4lBwjkergHzxWJ5AMuYL1DPrOtMPEqrTqOHfVzSZGsz9cMK4tDWETKKFBOM/5oSdGGW3oYvzcS0M=";
//		//网关公钥
//		String APIGW_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCMpjaWjngB4E3ATh+G1DVAmQnIpiPEFAEDqRfNGAVvvH35yDetqewKi0l7OEceTMN1C6NPym3zStvSoQayjYV+eIcZERkx31KhtFu9clZKgRTyPjdKMIth/wBtPKjL/5+PYalLdomM4ONthrPgnkN4x4R0+D4+EBpXo8gNiAFsNwIDAQAB";
//		//应用方加密串
//		String AES_Key = "8jTKCqZ9035g+HRzpZQqZA==";

		//1、网关公钥
		String APIGW_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCMpjaWjngB4E3ATh+G1DVAmQnIpiPEFAEDqRfNGAVvvH35yDetqewKi0l7OEceTMN1C6NPym3zStvSoQayjYV+eIcZERkx31KhtFu9clZKgRTyPjdKMIth/wBtPKjL/5+PYalLdomM4ONthrPgnkN4x4R0+D4+EBpXo8gNiAFsNwIDAQAB";
		//2、appid
		String APP_ID = "11000000000000029313";
		//3、密钥对认证方式，公钥在API平台登记，此处为私钥
		String MY_PRIVATE_KEY = "MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQC96zrfaBT4YOoLErhTaFnv0De1K3ZsZRQDGm3dIF8wHX/Rqg2sz5hfJexMwNgTepHdxrpveq8bog9jny8CtCT2etUD+NKT0gBYx4FzjCy1vtJzO1BqyzqzHA+GMsFQ/CYucRo25SJRv9szJD7d0SlnD0rnJWnbCuK+OgzM1ixCeUKsF/94Fgbo95UeW6EhH8H4VwNNrWRZei+eLfkIoHMSTB9D2g58i5S++/oieLg52MRd35x3pm60ipcGTgLpLi0xJGNB3dDDNA/UG3D7jbpLha3+eX1SaKU3jmTZYyLBFRe4fuY1LJq8gI03KGNHhPsbu1Gn8q9H7pcK3O1JAqStAgMBAAECggEAPiRuCxO/aNYtPppNfd0zMGjtEXa7NRSNy8YmFKi2/MNqQ2xlNRpoPRnni+W9zgHZILwZ3MhD68LHTk2T0EqpnYzrjnUoUf3w5xvAm9JN/toFenb6BTeiaWDRI5QP9TPMOn3/md63sBAa5U0C1QnPhk1WsPNpA6c4Mg5EifG6YbVDPUbC8tGLA+l9KCtpYxHc48rcYwe4/Pq5zA3dCx4vcXahdXJh6ZFOG2JkmwROJZGdXmEpAuHuBRLnTzvaJuNSyi5i/+tr7g8IW/27MoVAFtv30YOqYBufOBXXTcfm64UGUfo1anEsVPwXC9UvYS+l0f8f/kKIF8GZSWRa4n2KcQKBgQDowKxRcSOYttJ7l5isXGs3ErvFyIB+ST6cgFjgRMl2gJOybv591dqeaVu5SBp83hKgTg1iftufzvxMpwpd1PVKMqK5MGMTxTuWmxlEh6YKa4QKu1H2D/x0D2YbxhOh2PvdJy18F5T5EQ2Tow7/rU7xfyjaXC0AvEyra9gjX9QWEwKBgQDQ41OcJh+VDIKV/y+fKqpS9Y8DeoZ7VCPPAzDQ1p2bA/eEzVzKViR6mZ6IzIJRlrQB93wvIa5KD84563mWoAX2dYn1iX/x7oLg55Dd/iR+BTRqCZJBiziUb/bSRbLeIEGCfpfCyKhoPuc0H60k4BWT7itkj4Cm1Ht3pJYMQKiyPwKBgQCKUa5WO/lekQ9nGYFGtSmWMhDbCjuqURbfZLrslJRxUxnzCVk+KO/iAlTbOEldeY/yKlBz/1W/k/+GAiL7/knDTXI8wc+veR/fcc7DViXLvXdb9VRQ+dEam+gfi0gxf8S1+cljHJSQq5y450dLlI/8nogFtI+eB0k8+jsZUqK0dwKBgQCE6I+TZAJmUK5qCBNh38C9xjZ3zSbyI6ghGHOf/V4Meuqrmgs3RrYxN7tSaWVlylDAi5p9Vp3Ry9q4qaYUe78vgLwF+bXp1ot51H0tcn3/nQoriemAQLgAYnkWc3iKstVb1XZ0Xj4hDh0H4jvFobq5BCqh8li2Ta49gwBhzWZI+wKBgQCTHyWu3M6FtClYFHm2T3rOpTvjE/3xWZ3gMPsk8bMuyPZPEP83HJGVyBtwlbr05JMtZ1rEaPsVVQn0U1Qp0z+8tl4I9F+fJiUmu0/2/hS2iFsDKdZGJnfAM8APG6K7ID5Km8CnmnPX/ynBA1kpucIRUDnUwbGcfEbf2ufhPd10dg==";
		String AES_Key = "u1NKBJOMzvkHFvGiKbsq3g==";
		DefaultIcbcClient client = new DefaultIcbcClient(APP_ID, IcbcConstants.SIGN_TYPE_CA_SM_ICBC,
				MY_PRIVATE_KEY, IcbcConstants.CHARSET_UTF8, IcbcConstants.FORMAT_JSON, APIGW_PUBLIC_KEY,
				IcbcConstants.ENCRYPT_TYPE_AES, AES_Key, "", "");
		JftApiB2bpayTransqueryRequestV1 request = new JftApiB2bpayTransqueryRequestV1();
		request.setServiceUrl("https://apipcs3.dccnet.com.cn/api/jft/api/b2bpay/transquery/V1");

		JftApiB2bpayTransqueryRequestV1.JftApiB2bpayTransqueryRequestV1Biz bizContent = new
				JftApiB2bpayTransqueryRequestV1.JftApiB2bpayTransqueryRequestV1Biz();
		bizContent.setAppId(APP_ID);
//		bizContent.setOutVendorId("0202407150000011719");
//		bizContent.setOutUserId("874");
//		bizContent.setCardNo("1302010109024596014");
//		bizContent.setCardNo("9558851302001955895");
//		bizContent.setPayAccount("990204011101001401");
		bizContent.setStartTrxDate("20240724");
		bizContent.setEndTrxDate("20240726");
		bizContent.setStartId("1");
		bizContent.setEndId("50");
		bizContent.setType("00");
		request.setBizContent(bizContent);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("key",request);
		String a = jsonObject.toJSONString();
		JftApiB2bpayTransqueryResponseV1 response;
		try {
			//到账通知交易流水查询
			response = client.execute(request);
			log.info("到账通知交易流水状态" + response.getStatus());
			log.info("到账通知交易流水结果" + response.getErrordesc());
			if ("00".equals(response.getStatus())) {
				return R.ok(response.getDatalist());
			} else {
				return R.failed();
			}
		} catch (IcbcApiException e) {
			e.printStackTrace();
			return R.ok();
		}
	}

	@Override
	public R getIcbcTransactionFlowNew() throws IcbcApiException {
		log.info("开始推当日新增网银到账明细条数");

		String tranDate = DateUtil.getThisDay();
		// 测试时改为查10天内的，上线改为查当天内的
		// String beginDate = DateUtil.addDay(-10).replace("-","");
		String beginDate = tranDate;
		String endDate = tranDate;

		return getIcbcTransactionFlowCommon(tranDate,beginDate,endDate);
	}

	@Override
	public R getIcbcTransactionFlowYesterdayInner() throws IcbcApiException {
		log.info("开始推昨日新增网银到账明细条数");

		String tranDate = DateUtil.addDay(-1).replace("-","");
		String beginDate = tranDate;
		String endDate = tranDate;

		return getIcbcTransactionFlowCommon(tranDate,beginDate,endDate);
	}


	/**
	 * 新增网银到账明细条数公共处理
	 *
	 * @author cyx
	 * @date 2024-09-26
	 * @since mvp1.6.11
	 */
	private R getIcbcTransactionFlowCommon(String tranDate, String beginDate, String endDate) throws IcbcApiException {
		// 获取当前时间
		LocalTime currentTime = LocalTime.now();
		// 使用DateTimeFormatter格式化
		DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HHmmssSSS");
		String formattedTime = currentTime.format(formatter);

		DefaultIcbcClient client = new DefaultIcbcClient(icbcConfigProperties.getAppId(), IcbcConstants.SIGN_TYPE_CA_SM_ICBC,
				icbcConfigProperties.getAppPrivateKey(), IcbcConstants.CHARSET_UTF8, IcbcConstants.FORMAT_JSON, null,
				null, null, icbcConfigProperties.getCaSm(), null);
		client.setIcbc_ca(icbcConfigProperties.getCaSmIcbc());

		// 查需要获取流水的账号
		List<Map<String,String>> accountList = baseMapper.getAccountList();
		if (accountList.isEmpty()) {
			return R.ok();
		}

		// 查询当天的所有入账记录数据, 查账号和流水号
		List<Map<String,String>> serioList = baseMapper.getAllserioNo();
		// 整理各个账户下的流水：账号为key，账户下流水号列表作为value
		Map<String,List<String>> serioMapByAccount = new HashMap<>();
		if (!serioList.isEmpty()) {
			for(Map<String,String> serio: serioList) {
				List<String> serioListByAccountOne = serioMapByAccount.get(serio.get("receiveBkNo"));
				if(serioListByAccountOne == null || serioListByAccountOne.isEmpty()){
					serioListByAccountOne = new ArrayList<>();
				}

				serioListByAccountOne.add(serio.get("onlySequence"));
				serioMapByAccount.put(serio.get("receiveBkNo"),serioListByAccountOne);
			}
		}

		// 账号为key，账户名称作为value
		Map<String,String> accountInfoMap = new HashMap<>();
		// 账号为key，账号下的流水作为value
		Map<String,List<MybankEnterpriseTradeQhisdResponseV1.MybankEnterpriseTradeQhisdResponseRdV1>> accountRecordListMap = new HashMap<>();

		// 定义请求工行需要的传参对象
		MybankEnterpriseTradeQhisdRequestV1.MybankEnterpriseTradeQhisdRequestBizV1 bizContent;
		MybankEnterpriseTradeQhisdRequestV1 request;

		for(Map<String,String> accountInfo: accountList) {

			bizContent = new MybankEnterpriseTradeQhisdRequestV1.MybankEnterpriseTradeQhisdRequestBizV1();
			request = new MybankEnterpriseTradeQhisdRequestV1();

			bizContent.setTranDate(tranDate);
			bizContent.setTranTime(formattedTime);
			bizContent.setTransCode("QHISD");
			bizContent.setLanguage("zh_CN");
			String fSeqNo = "AHWX" + System.currentTimeMillis();
			bizContent.setfSeqno(fSeqNo);
			bizContent.setAccountNo(accountInfo.get("bank_no"));
			bizContent.setBeginDate(beginDate);
			bizContent.setEndDate(endDate);
			bizContent.setDrcrf("2");

			request.setServiceUrl(icbcConfigProperties.getServerUrl());
			request.setBizContent(bizContent);
			MybankEnterpriseTradeQhisdResponseV1 response = client.execute(request);
			if(response.isSuccess()) {
				// 获取所有账号的流水，每个账号存一个流水
				accountRecordListMap.put(accountInfo.get("bank_no"),response.getRd());
				if(accountInfo.get("bank_no").equals(response.getAccountNo())){
					accountInfoMap.put(accountInfo.get("bank_no"),response.getAccountName());
				}
			}
		}

		// 重新过滤已存入【入账记录】的流水信息
		if(accountRecordListMap.keySet().size()>0){
			for (String account : accountRecordListMap.keySet()) {
				// 获取当前账号下的流水
				List<MybankEnterpriseTradeQhisdResponseV1.MybankEnterpriseTradeQhisdResponseRdV1> flowRecordList = accountRecordListMap.get(account);

				// 获取成功后根据流水号去重和根据借贷标志02筛选出所有数据
				if (!flowRecordList.isEmpty()) {

					log.info("获取当前账号下的流水--明细条数:" + flowRecordList.size());
					for (MybankEnterpriseTradeQhisdResponseV1.MybankEnterpriseTradeQhisdResponseRdV1 entry : flowRecordList) {
						log.info("获取当前账号下的流水--来款单位:" + entry.getRecipName());
						log.info("获取当前账号下的流水--交易类型:" + entry.getDrcrf());
						log.info("获取当前账号下的流水--来款账户:" + entry.getRecipAccountNo());
						log.info("获取当前账号下的流水--交易时间:" + entry.getBusiDate() + " "
								+ entry.getBusiTime().replace(".",":"),DateUtil.DATETIME_PATTERN_MINUTE);
						log.info("获取当前账号下的流水--流水号:" + entry.getOnlySequence());
					}

					// 获取当前账户下的入账记录：账号为key，账户下入账记录列表作为value
					List<String> serioListByAccount = serioMapByAccount.get(account);
					if(serioListByAccount == null || serioListByAccount.isEmpty()){
						serioListByAccount = new ArrayList<>();
					}

					// 过滤出需要新增流水的数据
					List<MybankEnterpriseTradeQhisdResponseV1.MybankEnterpriseTradeQhisdResponseRdV1> insertList = new ArrayList<>();
					// 入账金额大于0再记录
					for (MybankEnterpriseTradeQhisdResponseV1.MybankEnterpriseTradeQhisdResponseRdV1 flowRecord : flowRecordList) {
						if("2".equals(flowRecord.getDrcrf())
								&& flowRecord.getCreditAmount() > 0
								&& !serioListByAccount.contains(flowRecord.getOnlySequence())){
							insertList.add(flowRecord);
						}
					}

					// 重新存入账号流水Map里
					accountRecordListMap.put(account, insertList);
				}
			}

			// 存入过滤后的流水信息到【入账记录】
			for (String account : accountRecordListMap.keySet()) {
				List<MybankEnterpriseTradeQhisdResponseV1.MybankEnterpriseTradeQhisdResponseRdV1> saveList = accountRecordListMap.get(account);
				// 封装数据
				if (saveList != null && !saveList.isEmpty()) {
					String bankName = accountInfoMap.get(account);
					log.info("需要存的流水到账--银行名称:" + bankName);
					log.info("需要存的流水到账--明细条数:" + saveList.size());
					try {
						for (MybankEnterpriseTradeQhisdResponseV1.MybankEnterpriseTradeQhisdResponseRdV1 entry : saveList) {
							EKPEntryPushParam pushParam = new EKPEntryPushParam();
							initValue(entry, pushParam, bankName, account);
							String body = sendToEkp(pushParam);
							// 重试一次
							if (StringUtils.isBlank(body)) {
								sendToEkp(pushParam);
							}
						}
					}catch (Exception e) {
						log.error("到账明细数据推送失败",e);
					}
				}
			}
		}

		return R.ok();
	}

	//推送数据
	private String sendToEkp(EKPEntryPushParam pushParam){
		RestTemplate yourRestTemplate = new RestTemplate();
		try{
			String formValues = new ObjectMapper().writeValueAsString(pushParam);
			//指向EKP的接口url
			//把ModelingAppModelParameterAddForm转换成MultiValueMap
			MultiValueMap<String,Object> wholeForm = new LinkedMultiValueMap<>();
			wholeForm.add("docSubject",ekpEntryProperties.getEntryDocSubject());
			wholeForm.add("docCreator", "{\"LoginName\":\"admin\"}");
			wholeForm.add("docStatus", ekpEntryProperties.getEntryDocStatus());
			wholeForm.add("fdModelId", ekpEntryProperties.getEntryFdModelId());
			wholeForm.add("fdFlowId", ekpEntryProperties.getEntryFdFlowId());
			wholeForm.add("formValues", formValues);
			HttpHeaders headers = new HttpHeaders();
			//如果EKP对该接口启用了Basic认证，那么客户端需要加入
			//addAuth(headers,"yourAccount"+":"+"yourPassword");是VO，则使用APPLICATION_JSON
			headers.setContentType(MediaType.MULTIPART_FORM_DATA);
			//必须设置上传类型，如果入参是字符串，使用MediaType.TEXT_PLAIN；如果
			HttpEntity<MultiValueMap<String,Object>> entity = new HttpEntity<>(wholeForm,headers);
			//有返回值的情况 VO可以替换成具体的JavaBean
			log.info("入账明细推送EKP开始,formValues:"+formValues);
			ResponseEntity<String> obj = yourRestTemplate.exchange(ekpEntryProperties.getEntryUrl(), HttpMethod.POST, entity, String.class);
			String body = obj.getBody();
			if (StringUtils.isBlank(body)){
				log.error("入账明细交易失败:"+obj);
				return null;
			}else{
				log.info("入账明细交易成功："+obj);
				return body;
			}
		}catch (Exception e){
			log.error("入账明细交易失败:", e);
			return null;
		}
	}

	/**
	 * @Description: 根据银行卡号查询银行信息
	 * @Author: huyc
	 * @Date: 2024-11-12
	 * @return: R
	 **/
	@Override
	public R<EkpBankCodeSet> querybankinfo(String cardNo) {

		String privateKey = "4d931f6ad4331158fcc4dea23f0d71393328146e40b5f63f197b9f6ad3732f44";

		String APIGW_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCMpjaWjngB4E3ATh+G1DVAmQnIpiPEFAEDqRfNGAVvvH35yDetqewKi0l7OEceTMN1C6NPym3zStvSoQayjYV+eIcZERkx31KhtFu9clZKgRTyPjdKMIth/wBtPKjL/5+PYalLdomM4ONthrPgnkN4x4R0+D4+EBpXo8gNiAFsNwIDAQAB";

//		DefaultIcbcClient client = new DefaultIcbcClient("11000000000000019038", IcbcConstants.SIGN_TYPE_CA_SM_ICBC,privateKey, APIGW_PUBLIC_KEY)
		DefaultIcbcClient client = new DefaultIcbcClient("11000000000000019038", IcbcConstants.SIGN_TYPE_CA_SM_ICBC, privateKey,
				IcbcConstants.CHARSET_UTF8, IcbcConstants.FORMAT_JSON, null,
				null, null, icbcConfigProperties.getCaSm(), null);
		client.setIcbc_ca(icbcConfigProperties.getCaSmIcbc());
		// 返回
		MybankEnterpriseAccountQuerybankinfoResponseV1 response = null;
		try {
			MybankEnterpriseAccountQuerybankinfoRequestV1.MybankEnterpriseAccountQuerybankinfoRequestBizV1 bizContent =
					new MybankEnterpriseAccountQuerybankinfoRequestV1.MybankEnterpriseAccountQuerybankinfoRequestBizV1();
			MybankEnterpriseAccountQuerybankinfoRequestV1 request = new MybankEnterpriseAccountQuerybankinfoRequestV1();
			// 请对照接口文档用bizContent.setxxx()方法对业务上送数据进行赋值
			bizContent.setTransCode("QBKNC");
			// 当天
			String nowDate = DateUtil.getThisDay();
			bizContent.setTranDate(nowDate);
			bizContent.setTranTime("103231001");
			bizContent.setLanguage("zh_CN");
			bizContent.setfSeqNo("AHWX"+ System.currentTimeMillis());
			// 6217752510002149161
			bizContent.setCardNo(cardNo);
			request.setServiceUrl("https://gw.open.icbc.com.cn/api/mybank/enterprise/account/querybankinfo/V1");
			request.setBizContent(bizContent);
			response = client.execute(request);
			if (response.isSuccess()) {
				// 业务成功处理-存储起来
				EkpBankCodeSet codeSet = new EkpBankCodeSet();
				codeSet.setFdCreateTime(LocalDateTime.now());
				codeSet.setFdRecipientBankCode(response.getBankCode());
				codeSet.setFdPayeeAccount(cardNo);
				codeSet.setFdRecipientBank(response.getBankName());
				ekpBankCodeSetService.save(codeSet);
				return R.ok(codeSet);
			}
		} catch (Exception e) {
			log.error("银企付款任务，查询行号错误：", e);
		}
		return R.failed("未找到");
	}

	@Override
	public R saveIcbcManagerCard() {
		//应用id 应用方私钥 网关公钥 应用方加密串
		String APP_ID = "11000000000000015602";
		//应用方私钥
		String MY_PRIVATE_KEY = "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCudy1tOyVTSCjJD9ej/IXmIKHTBLJ3FPYyhUnAt65hXgTD7OJso3+1cc+AakLGTLrSm9pxxd2AsUkVbdYFsXyq0rQOkG71ULPrzYI/XfbIcjf8dleFkTlEi+bVNN3J3LzbY4uPhPztDbkcwBoawl1jhcGTkFdIUCfJ8s9zXAAKgHjeNLXwrdnfvlTn8sfJX3JvrQ9W1Ji2NhCzAg7/fgJ9wAmS+aWKKBuc3ge5DQYcTtIe8hBeKSh6WZkjdUOja6ytOwEGCA3KiCVTw42rP/njrMAR3rh2ptXQtlLekMIEtiN3QAnIWp8IDg8uBEKr0aye6m/IfKMNpbbyaKqaeBUhAgMBAAECggEAOp0rk+ElHx/FJBfAeQWj7rbT51NSqhNOy5ZgOvD7ExdFPpXdVGZxx4HfFuOcX4bz1UIrV8IEMvJc/WgTWYJRwgpcF/CKdryQVg6LTcLB4IIPMTCJIwSxWsgt2z+Rq/oPMR32i1dAqlvL707S9l6KhZ8wc+UwjcjwNTbwX29vTBdiTsFS6QJBaUytu+nHoHvVrpg4botifiokHR1JX0hWjxP/Dh29aooaIbSu80A2sRPLIvRtCzxGjfcZP+H1ZtE439SCguuI+pOqWWLmzUV743PkGPpYPnYXadajrYBz8R5Uysm0tRwV4Ir4TxeH9axUP4Z/agldDNk/xBtK+PcgAQKBgQDwtUjrnzm29w/IwZHHCNDYtqZV2N42WrZZQusUbJ92QXsPFJpe4LCG4Ek7OYONuKuGfK/KJ2vZzlf+HlxlG7D+Xq/5Cb5LbZtIdIkLceOt+omfwHDVTqCM0jodNWKoYBQtI6PsksHpWtAkzP5kGSj7IabaJwKD0wxcbHvs5VFWoQKBgQC5jJFEfUAFGlPSoABdq8BQoaJZg976msnAy2QJMZRG/iEMywHTKFhMBkk3d0qpphdgHJQUr/gMcUtx9zlRBbvY30IOnpM9+nYqRXXlffqYIByM+PeO7AyihYrFpWlVdOO/ezp0VN0QZ8XwlkaYcvADae53C8K7DKtkLlDV71qugQKBgQDstzspDIMznbAWG9aCx/aqyKS3k/ijt33QNnD8uv3uy+J7KCXP3GN9oKAj8CGhg9SbA4/U3APCRJxgOfdfL2ZWIUQpQx2zC+1DyebkLHJdrB8fzZ6pBxP4qN2hz9hgAWyWH5CbnI+6Lya2qioawmt83NE7hFWC0lA7rCwLAlGFQQKBgBmpf03hpMEP6xfuWR6banW8ZR/MRUKTteOcPbGn0cIf06JZUV9K7StWkznAnerotcLtMO3LiJrv8GdKsfqquFg+SHyNIgAoa79c6/lZexcfGdPFezehHf48Sf0b632ONRF+kY8VTZ2/PHkRz6G2A8v1Eq4USlJkZi/s1/E+sWQBAoGAMU8mm9SGWka1hPYOI3ONCzeBbRBNulcS7B7luGcEbhPwi0p77xciSUy64GSVjZboD/DX9n3m7rU2GIqr50gkpQuTW9N9PNr7z74Tk36bCp5MpEeybMOgv8hovEQBa5PoTbAm9qMf9Xm1whQXUzhjcWR7vT4qAg1A+QXX58G9EkA=";
		//网关公钥
		String APIGW_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCwFgHD4kzEVPdOj03ctKM7KV+16bWZ5BMNgvEeuEQwfQYkRVwI9HFOGkwNTMn5hiJXHnlXYCX+zp5r6R52MY0O7BsTCLT7aHaxsANsvI9ABGx3OaTVlPB59M6GPbJh0uXvio0m1r/lTW3Z60RU6Q3oid/rNhP3CiNgg0W6O3AGqwIDAQAB";
		//应用方加密串
		String AES_Key = "5xGJdh7qb+B95SUoxDlatg==";
		DefaultIcbcClient client = new DefaultIcbcClient(APP_ID, IcbcConstants.SIGN_TYPE_RSA2,
				MY_PRIVATE_KEY, IcbcConstants.CHARSET_UTF8, IcbcConstants.FORMAT_JSON,
				APIGW_PUBLIC_KEY, IcbcConstants.ENCRYPT_TYPE_AES, AES_Key, null, null);
		JftApiPayB2bpayGenpreorderRequestV1 request = new JftApiPayB2bpayGenpreorderRequestV1();
		request.setServiceUrl("https://apipcs3.dccnet.com.cn/api/jft/api/pay/b2bpay/genpreorder/V1");
		JftApiPayB2bpayGenpreorderRequestV1.JftApiPayB2bpayGenpreorderRequestV1Biz bizContent =
				new JftApiPayB2bpayGenpreorderRequestV1.JftApiPayB2bpayGenpreorderRequestV1Biz();
		bizContent.setAppId(APP_ID);
		bizContent.setOutOrderId("202406200000066688");
		bizContent.setPayMethod("05");
		bizContent.setMultiRecFlag("0");
		bizContent.setStlFlag("0");
		bizContent.setAsynFlag("0");
		bizContent.setOutVendorId("158742714");
		bizContent.setOutUserId("0202401200000000039");
//		bizContent.setRecAcctId("123654123");
//		bizContent.setPayerAcctId("1001765234");
		bizContent.setTradeTime("2024-06-21 10:41:56");
		bizContent.setTrxChannel("01");
		bizContent.setTrxIp("172.16.24.98");
		bizContent.setPayModeTool("5");
		bizContent.setPayPhoneno("18856151558");
		bizContent.setPayerType("1");
		bizContent.setOrderAmount("2.00");
		bizContent.setPayAmount("2.00");
		bizContent.setFloatRate("888");
		bizContent.setProvince("安徽");
		bizContent.setCity("合肥市");
		bizContent.setCounty("包河区");
		bizContent.setEmail("123456@icbc.com");
		bizContent.setPhone("1388888888");
		bizContent.setAddress("安徽");
		bizContent.setPost("5168845");
		bizContent.setPayRem("试一下");
		bizContent.setOrderRem("食品");
		bizContent.setAddRemark("食品");
		bizContent.setPayerName("aigc科技集团");
		bizContent.setPayerAcctNum("0200062009212528888");
		bizContent.setCurrency("001");
		bizContent.setPayerWalletId("1234567890123456789012");
		bizContent.setPayerWalletName("XXXXX有限公司");
		bizContent.setNotifyUrl("http://www.xxx.com");
		bizContent.setJumpUrl("http://www.xxx.com");
		JftApiPayB2bpayGenpreorderRequestV1.JftApiPayB2bpayGenpreorderRequestV1Biz.Good
				goodsInfo = new JftApiPayB2bpayGenpreorderRequestV1.JftApiPayB2bpayGenpreorderRequestV1Biz.Good();
		goodsInfo.setGoodsSeqno("1");
		goodsInfo.setGoodsName("牛肉干");
		goodsInfo.setGoodsNum("10");
		goodsInfo.setGoodsAmt("10");
		goodsInfo.setWeight("肉干");
		goodsInfo.setPrice("50");
		goodsInfo.setSellerAddress("13866668");
		goodsInfo.setSellerName("牛大");
		goodsInfo.setUnits("斤");
		goodsInfo.setOutVendorId("158742714");
//		JftApiPayB2bpayGenpreorderRequestV1.JftApiPayB2bpayGenpreorderRequestV1Biz.Good
//				goodsInfo2 = new JftApiPayB2bpayGenpreorderRequestV1.JftApiPayB2bpayGenpreorderRequestV1Biz.Good();
//		goodsInfo2.setGoodsSeqno("2");
//		goodsInfo2.setGoodsName("商品");
//		goodsInfo2.setGoodsNum("10");
//		goodsInfo2.setGoodsAmt("10");
//		goodsInfo2.setWeight("商品规格");
//		goodsInfo2.setPrice("50");
//		goodsInfo2.setSellerAddress("13866668");
//		goodsInfo2.setSellerName("张三");
//		goodsInfo2.setUnits("斤");
//		goodsInfo2.setOutVendorId("158742714");
		List<JftApiPayB2bpayGenpreorderRequestV1.JftApiPayB2bpayGenpreorderRequestV1Biz.Good> goodList = new ArrayList<>();
		goodList.add(goodsInfo);
//		goodList.add(goodsInfo2);
		bizContent.setGoodsInfo(goodList);
		JftApiPayB2bpayGenpreorderRequestV1.JftApiPayB2bpayGenpreorderRequestV1Biz.RecInfo
				recInfo1 = new JftApiPayB2bpayGenpreorderRequestV1.JftApiPayB2bpayGenpreorderRequestV1Biz.RecInfo();
		recInfo1.setOutVendorId("158742714");
		recInfo1.setRecAcctId("123654123");
		recInfo1.setTrxAmount("2.00");
		recInfo1.setOrderAmount("2.00");
//		JftApiPayB2bpayGenpreorderRequestV1.JftApiPayB2bpayGenpreorderRequestV1Biz.RecInfo
//				recInfo2 = new JftApiPayB2bpayGenpreorderRequestV1.JftApiPayB2bpayGenpreorderRequestV1Biz.RecInfo();
//		recInfo2.setOutVendorId("158742714");
//		recInfo2.setRecAcctId("04187335");
//		recInfo2.setTrxAmount("1.00");
//		recInfo2.setOrderAmount("1.00");
		List<JftApiPayB2bpayGenpreorderRequestV1.JftApiPayB2bpayGenpreorderRequestV1Biz.RecInfo> recList = new ArrayList<>();
		recList.add(recInfo1);
//		recList.add(recInfo2);
		bizContent.setRecList(recList);
		bizContent.setSummary("测试一下");
		bizContent.setPurpose("测试一下");
		request.setBizContent(bizContent);
		try {
			JftApiPayB2bpayGenpreorderResponseV1 responseV1 = client.execute(request);
			if ("00".equals(responseV1.getStatus())) {
				return R.ok();
			} else {
				return R.failed();
			}
		} catch (IcbcApiException e) {
			e.printStackTrace();
			return R.ok();
		}
	}

	@Override
	public R getEnterprisePayDowninstr() {
		DefaultIcbcClient client = new DefaultIcbcClient(icbcConfigProperties.getAppId(), IcbcConstants.SIGN_TYPE_CA_SM_ICBC,
				icbcConfigProperties.getAppPrivateKey(), IcbcConstants.CHARSET_UTF8, IcbcConstants.FORMAT_JSON, null,
				null, null, icbcConfigProperties.getCaSm(), null);
		client.setIcbc_ca(icbcConfigProperties.getCaSmIcbc());
		try {
			MybankEnterprisePayDowninstrRequestV1.MybankEnterprisePayDowninstrRequestBizV1 bizContent =
					new MybankEnterprisePayDowninstrRequestV1.MybankEnterprisePayDowninstrRequestBizV1();
			MybankEnterprisePayDowninstrRequestV1 request = new MybankEnterprisePayDowninstrRequestV1();
			// 请对照接口文档用bizContent.setxxx()方法对业务上送数据进行赋值
			bizContent.setTransCode("DOWNINSTR");
			bizContent.setTranDate("20241216");
			bizContent.setTranTime("103231001");
			bizContent.setBeginDate("20241216");
			bizContent.setEndDate("20241216");
			bizContent.setPayeeAccNo("6217788306000007495");
			bizContent.setLanguage("zh_CN");
			bizContent.setfSeqNo("WX1734341241340");
			bizContent.setServiceCode("PAYENT");
//			bizContent.setQryfSeqno("PAYENT411erji17023");
			request.setServiceUrl("https://gw.open.icbc.com.cn/api/mybank/enterprise/pay/downinstr/V1");
			request.setBizContent(bizContent);
			MybankEnterprisePayDowninstrResponseV1 response = client.execute(request);
			if (response.isSuccess()) {
				// 业务成功处理
				return R.ok();
			} else {
				return R.failed();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return R.ok();
	}

	@Override
	public R getMeatebillreceive() {
		DefaultIcbcClient client = new DefaultIcbcClient(icbcConfigProperties.getAppId(), IcbcConstants.SIGN_TYPE_CA_SM_ICBC,
				icbcConfigProperties.getAppPrivateKey(), IcbcConstants.CHARSET_UTF8, IcbcConstants.FORMAT_JSON, null,
				null, null, icbcConfigProperties.getCaSm(), null);
		client.setIcbc_ca(icbcConfigProperties.getCaSmIcbc());
		try {
			MybankEnterpriseAccountTradeinfoMeatebillreceiveRequestV1.MybankEnterpriseAccountDownebillRequesBizV1 bizContent =
					new MybankEnterpriseAccountTradeinfoMeatebillreceiveRequestV1.MybankEnterpriseAccountDownebillRequesBizV1();
			MybankEnterpriseAccountTradeinfoMeatebillreceiveRequestV1 request =
					new MybankEnterpriseAccountTradeinfoMeatebillreceiveRequestV1();
			bizContent.setTransCode("DownEBill");
			bizContent.setBankCode("6217788306000007495");
			bizContent.setCis("");
			bizContent.setLoginId("");
			bizContent.setTranDate("");
			bizContent.setTranTime("");
			bizContent.setfSeqno("");
			bizContent.setAreaCode("");
			bizContent.setNetCode("");
			bizContent.setTellerNo("");
			bizContent.setWorkDate("");
			bizContent.setTranSerialNo("");
			bizContent.setAcctNo("");
			bizContent.setCurrencyType("");
			bizContent.setReqReserved1("");
			bizContent.setReqReserved2("");
			bizContent.setReqReserved3("");
			bizContent.setReqReserved4("");
			bizContent.setfSeqno("");
			request.setServiceUrl("https://gw.open.icbc.com.cn/api/mybank/enterprise/account/tradeinfo/meatebillreceive/V1");
			request.setBizContent(bizContent);
			MybankEnterpriseAccountTradeinfoMeatebillreceiveResponseV1 response =
					client.execute(request);
			if (response.isSuccess()) {
				return R.ok();
			} else {
				return R.failed();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return R.ok();
	}

	private void initValue(MybankEnterpriseTradeQhisdResponseV1.MybankEnterpriseTradeQhisdResponseRdV1 entry,
						   EKPEntryPushParam pushParam,String bankName,String bankNo) throws ParseException {
		pushParam.setFd_recipName(entry.getRecipName());
		pushParam.setFd_recipAccountNo(entry.getRecipAccountNo());
		pushParam.setFd_recipBkName(entry.getRecipBkName());
		pushParam.setFd_date(entry.getBusiDate() + " " + entry.getBusiTime().replace(".",":"));
		pushParam.setFd_receiveBkName(bankName);
		pushParam.setFd_receiveBkNo(bankNo);
		pushParam.setFd_remark(entry.getSummary());
		pushParam.setFd_receiveMoney(String.valueOf(entry.getCreditAmount()/100.0));
		pushParam.setFd_daReal(DateUtil.parseDate(entry.getBusiDate() + " "
				+ entry.getBusiTime().replace(".",":"),DateUtil.DATETIME_PATTERN_MINUTE));
		pushParam.setFd_daTime(DateUtil.getCurrentDateTime());
		pushParam.setFd_onlySequence(entry.getOnlySequence());
	}
}
