package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author licancan
 * @description 商险办理批增入参
 * @date 2022-07-20 08:43:31
 */
@Data
@Schema(description = "商险办理批增入参")
public class InsuranceBatchParam implements Serializable {
	private static final long serialVersionUID = -2689686777914935788L;

	/**
	 * 项目id
	 */
	@Schema(description = "项目id")
	private String deptId;
	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 岗位
	 */
	@Schema(description = "岗位")
	private String post;

	/**
	 * 保单号
	 */
	@Schema(description = "保单号")
	private String policyNo;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;
	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;

	/**
	 * 商险购买地省名称
	 */
	@Schema(description = "商险购买地省名称")
	private String insuranceProvinceName;

	/**
	 * 商险购买地市名称
	 */
	@Schema(description = "商险购买地市名称")
	private String insuranceCityName;

	/**
	 * 商险办理省名称
	 */
	@Schema(description = "商险办理省名称")
	private String insuranceHandleProvinceName;

	/**
	 * 商险办理城市名称
	 */
	@Schema(description = "商险办理城市名称")
	private String insuranceHandleCityName;

	/**
	 * 结算月
	 */
	@Schema(description = "结算月")
	private String settleMonth;

	/**
	 * 备注
	 */
	@Schema(description = "备注")
	private String remark;

	/**
	 * 错误信息
	 */
	@Schema(description = "错误信息")
	private String errorMessage;

  	/***********************************以下字段由系统算出，前端不用传，是为了方便入库***********************************/
	/**
	 * 结算类型 (1、单独结算 2、合并结算-和工资一起结算)
	 */
	@JsonIgnore
	private Integer settleType;

	/**
	 * 医疗额度
	 */
	@JsonIgnore
	private String medicalQuota;

	/**
	 * 身故或残疾额度
	 */
	@JsonIgnore
	private String dieDisableQuota;
	/**
	 * 险种主键
	 */
	@JsonIgnore
	private Long insuranceTypeId;

	/**
	 * 费率
	 */
	@JsonIgnore
	private BigDecimal rate;

	/**
	 * 计费方式
	 */
	@JsonIgnore
	private Integer billingType;

	/**
	 * 商险购买地省code
	 */
	@JsonIgnore
	private Integer insuranceProvince;

	/**
	 * 商险购买地市code
	 */
	@JsonIgnore
	private Integer insuranceCity;

	/**
	 * 商险办理省code
	 */
	@JsonIgnore
	private Integer insuranceHandleProvince;

	/**
	 * 商险办理城市code
	 */
	@JsonIgnore
	private Integer insuranceHandleCity;

	/**
	 * 保单开始时间
	 */
	@JsonIgnore
	private LocalDate policyStart;

	/**
	 * 保单结束时间
	 */
	@JsonIgnore
	private LocalDate policyEnd;

	/**
	 * EKP的 是否BPO：  是  否
	 */
	@Schema(description = "是否BPO", name = "bpoFlag")
	@ExcelIgnore
	private String bpoFlag;

	@Schema(description = "项目名称")
	private String deptName;

	@Schema(description ="客户id")
	private String unitId;

	@Schema(description ="客户名称")
	private String unitName;

	@Schema(description ="客户编码")
	private String unitNo;

	/**
	 * 是否地市自购0是 1 否
	 */
	@Schema(description = "是否地市自购")
	private String isAdress;
}
