package com.yifu.cloud.plus.v1.yifu.permission.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 新权限-菜单表
 *
 * @author hyc
 * @date 2023-08-29 14:49:40
 */
@Data
public class SysMenuVo extends RowIndex implements Serializable {

	/**
	 * ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "ID 不能为空")
	@Length(max = 36, message = "ID 不能超过36 个字符")
	@ExcelAttribute(name = "ID", isNotEmpty = true, errorInfo = "ID 不能为空", maxLength = 36)
	@Schema(description = "ID")
	@ExcelProperty("ID")
	private String id;
	/**
	 * 菜单名称
	 */
	@Length(max = 20, message = "菜单名称 不能超过20 个字符")
	@ExcelAttribute(name = "菜单名称", maxLength = 20)
	@Schema(description = "菜单名称")
	@ExcelProperty("菜单名称")
	private String menuName;
	/**
	 * 上级菜单名称
	 */
	@Length(max = 20, message = "上级菜单名称 不能超过20 个字符")
	@ExcelAttribute(name = "上级菜单名称", maxLength = 20)
	@Schema(description = "上级菜单名称")
	@ExcelProperty("上级菜单名称")
	private String menuNameParent;
	/**
	 * 上级菜单id
	 */
	@Length(max = 36, message = "上级菜单id 不能超过36 个字符")
	@ExcelAttribute(name = "上级菜单id", maxLength = 36)
	@Schema(description = "上级菜单id")
	@ExcelProperty("上级菜单id")
	private String menuParentId;
	/**
	 * 表单ID
	 */
	@Length(max = 36, message = "表单ID 不能超过36 个字符")
	@ExcelAttribute(name = "表单ID", maxLength = 36)
	@Schema(description = "表单ID")
	@ExcelProperty("表单ID")
	private String modelId;
	/**
	 * 视图ID
	 */
	@Length(max = 36, message = "视图ID 不能超过36 个字符")
	@ExcelAttribute(name = "视图ID", maxLength = 36)
	@Schema(description = "视图ID")
	@ExcelProperty("视图ID")
	private String viewId;
	/**
	 * 授权状态（0启用、1禁用）
	 */
	@Length(max = 1, message = "授权状态（0启用、1禁用） 不能超过1 个字符")
	@ExcelAttribute(name = "授权状态（0启用、1禁用）", maxLength = 1)
	@Schema(description = "授权状态（0启用、1禁用）")
	@ExcelProperty("授权状态（0启用、1禁用）")
	private String permissionStatus;
	/**
	 * 删除状态（0是、1否）
	 */
	@Length(max = 1, message = "删除状态（0是、1否） 不能超过1 个字符")
	@ExcelAttribute(name = "删除状态（0是、1否）", maxLength = 1)
	@Schema(description = "删除状态（0是、1否）")
	@ExcelProperty("删除状态（0是、1否）")
	private String deleteStatus;
	/**
	 * 收入权限id
	 */
	@Length(max = 20, message = "收入权限id 不能超过20 个字符")
	@ExcelAttribute(name = "收入权限id", maxLength = 20)
	@Schema(description = "收入权限id")
	@ExcelProperty("收入权限id")
	private String incomeId;
	/**
	 * 客户权限id
	 */
	@Length(max = 20, message = "客户权限id 不能超过20 个字符")
	@ExcelAttribute(name = "客户权限id", maxLength = 20)
	@Schema(description = "客户权限id")
	@ExcelProperty("客户权限id")
	private String customerId;
	/**
	 * 合同权限id
	 */
	@Length(max = 20, message = "合同权限id 不能超过20 个字符")
	@ExcelAttribute(name = "合同权限id", maxLength = 20)
	@Schema(description = "合同权限id")
	@ExcelProperty("合同权限id")
	private String contractId;
	/**
	 * 商机权限id
	 */
	@Length(max = 20, message = "商机权限id 不能超过20 个字符")
	@ExcelAttribute(name = "商机权限id", maxLength = 20)
	@Schema(description = "商机权限id")
	@ExcelProperty("商机权限id")
	private String bussinessId;
	/**
	 * 报价单权限id
	 */
	@Length(max = 20, message = "报价单权限id 不能超过20 个字符")
	@ExcelAttribute(name = "报价单权限id", maxLength = 20)
	@Schema(description = "报价单权限id")
	@ExcelProperty("报价单权限id")
	private String quotationId;
	/**
	 * 项目权限id
	 */
	@Length(max = 20, message = "项目权限id 不能超过20 个字符")
	@ExcelAttribute(name = "项目权限id", maxLength = 20)
	@Schema(description = "项目权限id")
	@ExcelProperty("项目权限id")
	private String domainId;
	/**
	 * BU归属权限id
	 */
	@Length(max = 20, message = "BU归属权限id 不能超过20 个字符")
	@ExcelAttribute(name = "BU归属权限id", maxLength = 20)
	@Schema(description = "BU归属权限id")
	@ExcelProperty("BU归属权限id")
	private String buId;
	/**
	 * 条线类型权限id
	 */
	@Length(max = 20, message = "条线类型权限id 不能超过20 个字符")
	@ExcelAttribute(name = "条线类型权限id", maxLength = 20)
	@Schema(description = "条线类型权限id")
	@ExcelProperty("条线类型权限id")
	private String lineId;
	/**
	 * 部门权限id
	 */
	@Length(max = 20, message = "部门权限id 不能超过20 个字符")
	@ExcelAttribute(name = "部门权限id", maxLength = 20)
	@Schema(description = "部门权限id")
	@ExcelProperty("部门权限id")
	private String deptId;

	/**
	 * 事业部权限id
	 */
	@Schema(description = "事业部权限id")
	@Length(max = 20, message = "事业部权限id 不能超过20 个字符")
	@ExcelAttribute(name = "事业部权限id", maxLength = 20)
	@ExcelProperty("事业部权限id")
	private String divisionId;

	/**
	 * 事业部条线权限id
	 */
	@Schema(description = "事业部条线权限id")
	@Length(max = 20, message = "事业部条线权限id 不能超过20 个字符")
	@ExcelAttribute(name = "事业部条线权限id", maxLength = 20)
	@ExcelProperty("事业部条线权限id")
	private String divisionLineId;

}
