package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * 个税比例及速算扣除数的配置表
 *
 * @author hgw
 * @date 2019-07-30 15:00:05
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_salary_tax_config")
@Tag(name = "薪资配置-所得税配置")
public class TSalaryTaxConfig extends Model<TSalaryTaxConfig> {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "主键")
    private String id;
    /**
     * 累计预扣预缴应纳税所得额说明
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计预扣预缴应纳税所得额说明")
    @Length(max = 32, message = "累计预扣预缴应纳税所得额说明不能超过32个字符")
    @ExcelAttribute(name = "累计预扣预缴应纳税所得额说明", maxLength = 32)
    private String taxableIncomeRemark;
    /**
     * 预扣率（%）
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "预扣率（%）")
    @NotBlank(message = "预扣率（%）不能为空")
    @ExcelAttribute(name = "预扣率（%）", isNotEmpty = true, errorInfo = "预扣率（%）不能为空")
    private Integer withholdingRate;
    /**
     * 速算扣除数
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "速算扣除数")
    @NotBlank(message = "速算扣除数不能为空")
    @ExcelAttribute(name = "速算扣除数", isNotEmpty = true, errorInfo = "速算扣除数不能为空")
    private BigDecimal quickDeducation;
    /**
     * 最小区间值
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "最小区间值")
    @NotBlank(message = "最小区间值不能为空")
    @ExcelAttribute(name = "最小区间值", isNotEmpty = true, errorInfo = "最小区间值不能为空")
    private BigDecimal minIncome;
    /**
     * 最大区间值
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "最大区间值")
    @NotBlank(message = "最大区间值不能为空")
    @ExcelAttribute(name = "最大区间值", isNotEmpty = true, errorInfo = "最大区间值不能为空")
    private BigDecimal maxIncome;
    /**
     * 等级
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "等级")
    @NotBlank(message = "等级不能为空")
    @ExcelAttribute(name = "等级", isNotEmpty = true, errorInfo = "等级不能为空")
    private Integer level;

    /**
     * 类型：0：工资；1：年终奖
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "类型：0：工资；1：年终奖")
    @NotBlank(message = "类型不能为空")
    @ExcelAttribute(name = "类型", isNotEmpty = true, errorInfo = "类型不能为空")
    private Integer type;

    /**
     * 个税起征点或年终奖个税临界值
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "个税起征点或年终奖个税临界值")
    @ExcelAttribute(name = "个税起征点或年终奖个税临界值")
    private BigDecimal startPoint;

}
