/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsDeclarer;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 申报对象表
 *
 * @author huyc
 * @date 2022-08-11 10:56:10
 */
@Mapper
public interface TStatisticsDeclarerMapper extends BaseMapper<TStatisticsDeclarer> {
    /**
     * 申报对象表简单分页查询
     * @param tStatisticsDeclarer 申报对象表
     * @return
     */
    IPage<TStatisticsDeclarer> getTStatisticsDeclarerPage(Page<TStatisticsDeclarer> page, @Param("tStatisticsDeclarer") TStatisticsDeclarer tStatisticsDeclarer);

	/**
	 * @param
	 * @Description: 统计
	 * @return:
	 **/
	List<TStatisticsDeclarer> doStatisticsTaxDeclarer(@Param("nowMonth") String nowMonth, @Param("lastMonth") String lastYear);

	/**
	 * @param
	 * @Description: 统计
	 * @return:
	 **/
	List<TStatisticsDeclarer> doStatisticsTaxDeclarerYear(@Param("nowMonth") String nowMonth);

	/**
	 * @Description: 导出
	 * @Author: huyc
	 * @Date: 2023/1/12 14:52
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.social.vo.TForecastLibraryVo>
	 **/
	List<TStatisticsDeclarer> exportDeclarer(@Param("tStatisticsDeclarer") TStatisticsDeclarer tStatisticsDeclarer);
}
