package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TInsuranceUnpurchasePersonSalary;

import java.util.List;

/**
 * 含风险项目不购买申请明细表-薪资关联
 *
 * @author hgw
 * @date 2025-1-15 12:00:57
 */
public interface TInsuranceUnpurchasePersonSalaryService extends IService<TInsuranceUnpurchasePersonSalary> {
	/**
	 * 含风险项目不购买申请明细表简单分页查询-薪资关联
	 *
	 * @param tInsuranceUnpurchasePerson 含风险项目不购买申请明细表-薪资关联
	 * @return
	 */
	IPage<TInsuranceUnpurchasePersonSalary> getTInsuranceUnpurchasePersonSalaryPage(Page<TInsuranceUnpurchasePersonSalary> page, TInsuranceUnpurchasePersonSalary tInsuranceUnpurchasePerson);

	/**
	 * @param salaryId 工资id
	 * @Description: 删除并刷新次数
	 * @Author: hgw
	 * @Date: 2025/1/16 17:47
	 * @return: void
	 **/
	void deletePersonSalaryBySalaryId(String salaryId);

	/**
	 * @param parentIds 明细主表ids
	 * @Description: 刷新次数
	 * @Author: hgw
	 * @Date: 2025/1/16 17:47
	 * @return: void
	 **/
	void updatePersonSalaryNumByParentIds(List<String> parentIds);

}
